package models

import (
	"a.yandex-team.ru/drive/library/go/gosql"
)

func SetupDBs(
	dbConfigs map[string]gosql.Config,
) (map[string]*gosql.DB, error) {
	dbs := map[string]*gosql.DB{}
	for name, cfg := range dbConfigs {
		conn, err := gosql.NewDB(cfg)
		if err != nil {
			for _, conn := range dbs {
				_ = conn.Close()
			}
			return nil, err
		}
		dbs[name] = conn
	}
	return dbs, nil
}
