package exports

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/drive/analytics/gotasks"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/zootopia/analytics/drive/models"
)

func init() {
	updateCarInfoHistoryCmd := cobra.Command{
		Use: "update-car-info-history",
		Run: gotasks.WrapMain(updateCarInfoHistoryMain),
	}
	updateCarInfoHistoryCmd.Flags().String("yt-proxy", "hahn", "")
	ExportsCmd.AddCommand(&updateCarInfoHistoryCmd)
}

func updateCarInfoHistoryMain(ctx *gotasks.Context) error {
	yc, err := ctx.GetYT()
	if err != nil {
		return err
	}
	db, ok := ctx.DBs[ctx.Config.BackendDB]
	if !ok {
		return fmt.Errorf("database %q not found", ctx.Config.BackendDB)
	}
	exporter := NewExporter(
		models.CarEvent{}, "history_event_id",
		yc, ctx.Config.YTPaths.CarInfoHistoryTable,
		db, "drive_car_info_history",
		ypath.Path(""), nil,
	)
	exporter.MinBatchSize = 1
	return exporter.Export(ctx)
}
