package cars

import (
	"github.com/gofrs/uuid"
)

type IMEI struct {
	// BeginTime contains begin time for specified IMEI.
	BeginTime int64 `yson:"begin_time"`
	// EndTime contains end time of specified IMEI. If not present,
	// IMEI is current.
	EndTime int64 `yson:"end_time,omitempty"`
	// IMEI contains IMEI for specified period.
	IMEI uint64 `yson:"imei"`
}

type Head struct {
	// BeginTime contains begin time for specified IMEI.
	BeginTime int64 `yson:"begin_time"`
	// EndTime contains end time of specified IMEI. If not present,
	// IMEI is current.
	EndTime int64 `yson:"end_time,omitempty"`
	// HeadID contains IMEI for specified period.
	HeadID string `yson:"head_id"`
}

// Car contains car struct.
type Car struct {
	// CarID contains car ID.
	CarID uuid.UUID `json:"car_id" yson:"car_id"`
	// IMEI contains car IMEI.
	IMEI uint64 `json:"imei" yson:"imei"`
	// VIN contains car VIN.
	VIN string `json:"vin" yson:"vin"`
	// Model contains car model.
	Model string `json:"model" yson:"model"`
	// Tags contains list of tag names.
	Tags []string `json:"tag" yson:"tags"`
	// UnsafeDocuments contains map of unsafe documents.
	UnsafeDocuments map[string][]interface{} `json:"unsafe_documents" yson:"unsafe_documents"`
}

type ExtendedCar struct {
	Car
	// HeadID contains current car HeadID.
	HeadID string `yson:"head_id"`
	// IMEILog contains car IMEI log.
	IMEILog []IMEI `yson:"imei_log"`
	// HeadLog contains car Head log.
	HeadLog []Head `yson:"head_log"`
}
