package users

import (
	"github.com/gofrs/uuid"
)

type AdvToken struct {
	Type  string `yson:"type"`
	Token string `yson:"token"`
	Time  int64  `yson:"time"`
}

type Wallet struct {
	ID   int64  `yson:"id"`
	Name string `yson:"name"`
}

// User is used for collecting full information
// about user in one structure
//
// This struct represents flat table for convenient export to YT
type User struct {
	UserID        uuid.UUID `json:"" yson:"user_id"`
	Status        string    `json:"" yson:"status"`
	UID           int64     `json:"" yson:"uid"`
	RegisterTime  *int64    `json:"" yson:"register_time"`
	RegisterDBGeo string    `json:"" yson:"register_db_geo"`
	Username      string    `json:"" yson:"username"`
	Email         string    `json:"" yson:"email"`
	Phone         string    `json:"" yson:"phone"`
	PhoneVerified bool      `json:"" yson:"phone_verified"`
	// BonusBalance contains balance of bonus wallet.
	BonusBalance float64 `yson:"bonus_balance"`
	BonusTotal   float64 `yson:"bonus_total"`
	// Wallets contains wallets info.
	Wallets []Wallet `yson:"wallets"`
	// ParentID contains ID of user duplicate
	ParentID *string `yson:"parent_id"`
	// SecretID contains Yang Assignment ID
	SecretID *string `yson:"secret_id"`
	// DBFirstName.
	DBFirstName string `yson:"db_first_name"`
	// DBLastName.
	DBLastName string `yson:"db_last_name"`
	// DBMiddleName.
	DBMiddleName string `yson:"db_middle_name"`
}

type PlusSub struct {
	Begin int64  `yson:"begin"`
	End   int64  `yson:"end"`
	Type  string `yson:"type"`
}

// SocialProfile contains information about social profile.
type SocialProfile struct {
	URL string `yson:"url"`
}

// Tag contains information about user tag.
type Tag struct {
	Tag  string      `yson:"tag"`
	Data interface{} `yson:"data"`
}

type ExtendedUser struct {
	User
	Apps               []string               `yson:"apps"`
	CarsharingApps     []string               `yson:"carsharing_apps"`
	Features           map[string]interface{} `yson:"features"`
	Params             map[string]interface{} `yson:"params"`
	OrdersCount        int                    `yson:"orders_count"`
	FirstOrderTime     *int64                 `yson:"first_order_time"`
	LastOrderTime      *int64                 `yson:"last_order_time"`
	PaidOrdersCount    int                    `yson:"paid_orders_count"`
	FirstPaidOrderTime *int64                 `yson:"first_paid_order_time"`
	LastPaidOrderTime  *int64                 `yson:"last_paid_order_time"`
	TagsCount          map[string]int         `yson:"tags_count"`
	TagsCount1Month    map[string]int         `yson:"tags_count_1month"`
	Age                *float64               `yson:"age"`
	LicenseAge         *float64               `yson:"license_age"`
	Experience         *float64               `yson:"experience"`
	IsPlus             bool                   `yson:"is_plus"`
	PlusBeginTime      *int64                 `yson:"plus_begin_time"`
	PlusEndTime        *int64                 `yson:"plus_end_time"`
	PlusSubs           []PlusSub              `yson:"plus_subs"`
	SocialProfiles     []SocialProfile        `yson:"social_profiles"`
	CurrentCity        string                 `yson:"current_city"`
	CityOrderCounts    map[string]int         `yson:"city_order_counts"`
	WalletTotals       map[string]float64     `yson:"wallet_totals"`
	// OrderNameCounts contains counts of orders for each tariff name.
	OrderNameCounts map[string]int `yson:"order_name_counts"`
	// OrderTypeCounts contains counts of orders for each offer type.
	OrderTypeCounts map[string]int `yson:"order_type_counts"`
	// AppSettings contains user applications settings.
	AppSettings map[string]string `yson:"app_settings"`
	// ShownLandings contains landings that viewed by user.
	ShownLandings []string `yson:"shown_landings"`
	// LastTaxiAcceptedSurgeTime.
	LastTaxiAcceptedSurgeTime *int64 `yson:"last_taxi_accepted_surge_time"`
	// LastAutoVehicleSearchTimes.
	LastAutoVehicleSearchTimes map[string]int64 `yson:"last_auto_vehicle_search_times"`
	// Tags contains user tags.
	Tags []string `yson:"tags"`
	// UserTags contains user tags with data.
	UserTags []Tag `yson:"user_tags"`
	// ActiveRoles contains list of active roles.
	ActiveRoles []string `yson:"active_roles"`
	// PassiveRoles contains list of passive roles.
	PassiveRoles []string `yson:"passive_roles"`
	// LastActiveTime contains time of last activity of user.
	LastActiveTime *int64 `yson:"last_active_time"`
	// LastDeviceID.
	LastDeviceID string `yson:"last_device_id"`
	// LastDeviceIDHash.
	LastDeviceIDHash uint64 `yson:"last_device_id_hash"`
	// LastPlatform.
	LastPlatform string `yson:"last_platform"`
	// DeviceIDs.
	DeviceIDs []string `yson:"device_ids"`
	// DeviceIDHashes.
	DeviceIDHashes []uint64 `yson:"device_id_hashes"`
	// Platforms.
	Platforms string `yson:"platforms"`
	// GoodPassportPhotos.
	GoodPassportPhotos bool `yson:"good_passport_photos"`
	// GoodLicensePhotos.
	GoodLicensePhotos bool `yson:"good_license_photos"`
	// AdvTokens
	AdvTokens []AdvToken `yson:"adv_tokens"`
	// RenisKBM contains KBM value from renis.
	RenisKBM *float64 `yson:"renis_kbm"`
	// Passport fields.
	PassportNumber        string `json:"" yson:"passport_number"`
	PassportFirstName     string `json:"" yson:"passport_first_name"`
	PassportLastName      string `json:"" yson:"passport_last_name"`
	PassportMiddleName    string `json:"" yson:"passport_middle_name"`
	PassportGender        string `json:"" yson:"passport_gender"`
	PassportBirthPlace    string `json:"" yson:"passport_birth_place"`
	PassportBirthDate     *int64 `json:"" yson:"passport_birth_date"`
	PassportIssueDate     *int64 `json:"" yson:"passport_issue_date"`
	PassportExpireDate    *int64 `json:"" yson:"passport_expire_date"`
	PassportRegExpireDate *int64 `json:"" yson:"passport_reg_expire_date"`
	PassportCitizenship   string `json:"" yson:"passport_citizenship"`
	PassportBioCountry    string `json:"" yson:"passport_bio_country"`
	PassportRegCountry    string `json:"" yson:"passport_reg_country"`
	PassportRegApartment  string `json:"" yson:"passport_reg_apartment"`
	PassportRegHousing    string `json:"" yson:"passport_reg_housing"`
	PassportRegLetter     string `json:"" yson:"passport_reg_letter"`
	PassportRegHouse      string `json:"" yson:"passport_reg_house"`
	PassportRegStreet     string `json:"" yson:"passport_reg_street"`
	PassportRegArea       string `json:"" yson:"passport_reg_area"`
	PassportRegLocality   string `json:"" yson:"passport_reg_locality"`
	PassportRegRegion     string `json:"" yson:"passport_reg_region"`
	PassportRegType       string `json:"" yson:"passport_reg_type"`
	// License fields.
	LicenseNumber         string `json:"" yson:"license_number"`
	LicenseNumberFront    string `json:"" yson:"license_number_front"`
	LicenseNumberBack     string `json:"" yson:"license_number_back"`
	LicenseFirstName      string `json:"" yson:"license_first_name"`
	LicenseLastName       string `json:"" yson:"license_last_name"`
	LicenseMiddleName     string `json:"" yson:"license_middle_name"`
	LicenseIssueDate      *int64 `json:"" yson:"license_issue_date"`
	LicenseFirstIssueDate *int64 `json:"" yson:"license_first_issue_date"`
	LicenseExpireDate     *int64 `json:"" yson:"license_expire_date"`
	LicenseBirthDate      *int64 `json:"" yson:"license_birth_date"`
	LicenseCountry        string `json:"" yson:"license_country"`
	LicenseCountryFront   string `json:"" yson:"license_country_front"`
	LicenseCountryBack    string `json:"" yson:"license_country_back"`
}

// SocialProfilesRow represents YT table row.
type SocialProfilesRow struct {
	// UserId contains user id
	UserID uuid.UUID `yson:"user_id"`
	// Profiles contains list of social profiles.
	Profiles []SocialProfile `yson:"profiles"`
}

type AutoVehicleSearchEvent struct {
	Time      int64  `yson:"time"`
	Nameplate string `yson:"nameplate"`
}

type UserAppsRow struct {
	UserID   uuid.UUID `yson:"user_id"`
	DeviceID string    `yson:"device_id"`
	Apps     []string  `yson:"apps"`
	// TaxiAcceptedSurgeTime contains list of times of accepted surges.
	TaxiAcceptedSurgeTimes []int64 `yson:"taxi_accepted_surge_time"`
	// AutoVehicleSearchEvents contains events of Auto.Ru vehicle search.
	AutoVehicleSearchEvents []AutoVehicleSearchEvent `yson:"auto_vehicle_search_events"`
}

type PlusRow struct {
	UserID        uuid.UUID `yson:"user_id"`
	PlusSubs      []PlusSub `yson:"plus_subs"`
	PlusBeginTime *int64    `yson:"plus_begin_time"`
	PlusEndTime   *int64    `yson:"plus_end_time"`
}
