package taxidwh

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/drive/analytics/goback/models"
	"a.yandex-team.ru/drive/library/go/clients/taxidwh"
	"a.yandex-team.ru/drive/library/go/gosql"
	"a.yandex-team.ru/zootopia/library/go/db/events"
	"a.yandex-team.ru/zootopia/library/go/goyt"
)

func init() {
	exportCompiledRidesCmd := cobra.Command{
		Use: "export-compiled-rides",
		Run: deliveryMain(compiledRidesDelivery{}),
	}
	TaxiDWHCmd.AddCommand(&exportCompiledRidesCmd)
	ytExportCompiledRidesCmd := cobra.Command{
		Use: "export-compiled-rides",
		Run: ytDeliveryMain(compiledRidesDelivery{}),
	}
	YTTaxiDWHCmd.AddCommand(&ytExportCompiledRidesCmd)
}

type compiledRidesDelivery struct{}

func (d compiledRidesDelivery) RuleName() string {
	return "drive_analytics_compiled_rides"
}

func (d compiledRidesDelivery) EventStore(db *gosql.DB) events.ROStore {
	return events.NewStore(
		models.CompiledRide{}, "history_event_id", "compiled_rides",
		getDialect(db),
	)
}

func (d compiledRidesDelivery) EventDocument(
	event events.Event,
) (taxidwh.Document, error) {
	ride := event.(models.CompiledRide)
	data := map[string]interface{}{
		"history_event_id":      ride.HistoryEventID,
		"history_action":        ride.HistoryAction,
		"history_timestamp":     ride.HistoryTimestamp,
		"history_user_id":       ride.HistoryUserID,
		"history_originator_id": ride.HistoryOriginatorID,
		"history_comment":       ride.HistoryComment,
		"session_id":            ride.SessionID,
		"object_id":             ride.ObjectID,
		"price":                 ride.Price,
		"duration":              ride.Duration,
		"start":                 ride.Start,
		"finish":                ride.Finish,
	}
	rideData, err := ride.ParseData()
	if err != nil {
		return taxidwh.Document{}, err
	}
	data["parsed_data"] = mongoFix(rideData)
	return taxidwh.Document{
		ID:   fmt.Sprint(ride.HistoryEventID),
		Data: data,
	}, nil
}

func (d compiledRidesDelivery) ScanEvent(
	r goyt.TableReader,
) (events.Event, error) {
	var row models.CompiledRide
	if err := r.Scan(&row); err != nil {
		return nil, err
	}
	return row, nil
}
