# -*- coding: utf-8 -*-

from os import environ
from os.path import abspath, dirname, exists


class Secret(object):
    def __init__(self, name):
        self.name = name
        self.__cached = False
        self.__value = None

    def __str__(self):
        if not self.__cached:
            if self.name + "_FILE" in environ:
                file_path = environ[self.name + "_FILE"]
                if exists(file_path):
                    with open(file_path, "r") as fd:
                        self.__value = fd.read().rstrip()
            else:
                self.__value = environ.get(self.name, "")
            self.__cached = True
        return self.__value

    def __repr__(self):
        return "{}(\"{}\")".format(type(self).__name__, self.name)


BASE_DIR = abspath(dirname(__file__))

# You can get this token here:
# https://oauth.yt.yandex.net/
YT = {
    "proxy": "hahn",
    "token": Secret("YT_TOKEN"),
    "home_path": "//home/carsharing/development",
    "temp_path": "//home/carsharing/development/tmp",
    "pool": "carsharing",
}

YQL = {
    "token": Secret("YQL_TOKEN"),
}

REPL_YT = {
    "proxy": "arnold",
    "token": Secret("REPL_YT_TOKEN"),
    "home_path": "//home/carsharing/development",
    "temp_path": "//home/carsharing/development/tmp",
    "pool": "carsharing",
}

ANIMALS = {
    "host": "animals.search.yandex.net",
    "port": 4004,
    "login": "drive",
    "token": Secret("ANIMALS_TOKEN"),
}

DB = {
    "host": environ.get("DB_HOST"),
    "port": int(environ.get("DB_PORT", 5432)),
    "user": environ.get("DB_USER", "postgres"),
    "password": Secret("DB_PASSWORD"),
    "name": environ.get("DB_NAME", "postgres"),
}

DB_URL = (
    "postgresql+psycopg2://{user}:{password}@{host}:{port}/{name}".format(
        host=DB["host"],
        port=DB["port"],
        name=DB["name"],
        user=DB["user"],
        password=str(DB["password"]),
    )
)

DB_ECHO = True

DB_CONNECT_ARGS = dict(
    target_session_attrs="read-write",
)

TVM2 = {
    "source": 2011194,
    "secret": Secret("TVM2_SECRET"),
    "targets": {
        "solomon": 2010242,
        "geocoder": 2001886,
    },
}

SOLOMON = {
    "cluster": "development",
    "project": "carsharing_analytics",
}

LICENSE_CHECKS = {
    "table": "data/user/_license_check_task",
    "callbacks": {
        "taxi": dict(
            target=2001734,
            endpoint="http://antifraud-py.taxi.yandex.net/v1/save_license_check_result",
            debug=False,
        ),
        "taxi-testing": dict(
            target=2001736,
            endpoint="http://antifraud-py.taxi.tst.yandex.net/v1/save_license_check_result",
            debug=True,
        ),
        "taxi-debug": dict(
            target=2013636,
            endpoint="http://antifraud-py.taxi.tst.yandex.net/v1/save_license_check_result",
            debug=True,
        ),
    },
}

DRIVE = {
    "endpoint": "https://prestable.carsharing.yandex.net",
}

CAR_DAMAGES = {
    "cars_attr_table": "//home/carsharing/production/data/cars/cars_attr",
    "mds_bucket": "carsharing-acceptances",
    "drive_images_history": "//home/carsharing/production/db_dumps/drive_images_history",
    "latest_photos_table": "//home/carsharing/production/toloka/car_damages/element_classifier/latest_photos",
    "statistical_detection": True,
    # Selection step.
    "selection_step_overlap": 3,
    "selection_step_project_id": "31590",
    "selection_step_results_table": "//home/carsharing/production/toloka/car_damages/selection_step/results",
    "selection_step_daily_photos_table": "//home/carsharing/production/toloka/car_damages/selection_step/daily_photos",
    "selection_step_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "selection_step_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
    # Second step exterior.
    "second_step_exterior_overlap": 3,
    "second_step_exterior_project_id": "31592",
    "second_step_exterior_results_table": "//home/carsharing/production/toloka/car_damages/second_step_exterior/results",
    "second_step_exterior_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "second_step_exterior_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
    # Second step interior.
    "second_step_interior_overlap": 3,
    "second_step_interior_project_id": "31594",
    "second_step_interior_results_table": "//home/carsharing/production/toloka/car_damages/second_step_interior/results",
    "second_step_interior_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "second_step_interior_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
    # Duplicates step.
    "duplicates_step_overlap": 3,
    "duplicates_step_project_id": "48309",
    "duplicates_step_results_table": "//home/carsharing/production/toloka/car_damages/duplicates_step/results",
    "duplicates_step_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "duplicates_step_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
    # Select best step.
    "select_best_step_overlap": 3,
    "select_best_step_project_id": "49298",
    "select_best_step_results_table": "//home/carsharing/production/toloka/car_damages/select_best_step/results",
    "select_best_step_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "select_best_step_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
    # Classification step.
    "classification_step_overlap": 3,
    "classification_step_project_id": "31595",
    "classification_step_last_uploaded_table": "//home/carsharing/production/toloka/car_damages/classification_step/last_uploaded_tasks",
    "classification_new_damages_table": "//home/carsharing/production/toloka/car_damages/new_damages_log",
    "classification_step_batch_size": int(environ.get("BATCH_SIZE", 18)),
    "classification_step_golden_size": int(environ.get("GOLDEN_SIZE", 2)),
}

DEBUG_MODE = environ.get("RUN_MODE") == "debug"
