# -*- coding: utf-8 -*-

from .base import *  # noqa: UnusedImport  # noqa: ImportStarUsed
from .base import DB, DRIVE, CAR_DAMAGES

from logging import basicConfig, INFO


basicConfig(
    level=INFO,
    format="%(asctime)s %(name)-20s %(levelname)-8s %(message)s",
    datefmt="%Y-%m-%d %H:%M:%S",
)

DB_URL = (
    "postgresql+psycopg2://{user}:{password}@{host}:{port}/{name}".format(
        host="c-mdbnnt2knmorkom789ms.rw.db.yandex.net",
        port=6432,
        name="drive_analytics_leasing",
        user="drive_analytics",
        password=str(DB["password"]),
    )
)

DRIVE["endpoint"] = "https://leasing-cabinet.carsharing.yandex.net"

CAR_DAMAGES["cars_attr_table"] = "//home/carsharing/leasing-cabinet-production/data/cars/cars_attr"
CAR_DAMAGES["mds_bucket"] = "carsharing-acceptances"
CAR_DAMAGES["drive_images_history"] = "//home/carsharing/leasing-cabinet-production/db_dumps/drive_images_history"
CAR_DAMAGES["latest_photos_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/element_classifier/latest_photos"

CAR_DAMAGES["selection_step_project_id"] = "73430"
CAR_DAMAGES["selection_step_results_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/selection_step/results"
CAR_DAMAGES["selection_step_daily_photos_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/selection_step/daily_photos"

CAR_DAMAGES["second_step_exterior_project_id"] = "73440"
CAR_DAMAGES["second_step_exterior_results_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/second_step_exterior/results"

CAR_DAMAGES["second_step_interior_project_id"] = "73442"
CAR_DAMAGES["second_step_interior_results_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/second_step_interior/results"

CAR_DAMAGES["duplicates_step_project_id"] = "73443"
CAR_DAMAGES["duplicates_step_results_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/duplicates_step/results"

CAR_DAMAGES["select_best_step_project_id"] = "73444"
CAR_DAMAGES["select_best_step_results_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/select_best_step/results"

CAR_DAMAGES["classification_step_project_id"] = "73445"
CAR_DAMAGES["classification_step_last_uploaded_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/classification_step/last_uploaded_tasks"
CAR_DAMAGES["classification_new_damages_table"] = "//home/carsharing/leasing-cabinet-production/toloka/car_damages/new_damages_log"

CAR_DAMAGES["statistical_detection"] = False
