# -*- coding: utf-8 -*-

from ticket_parser2.api.v1 import TvmClient, TvmApiClientSettings
from drive.analytics.pybase.config import TVM2


_tvm2_client = None


def get_tvm2():
    """get_tvm2 returns TVM2 client singleton.
    """
    global _tvm2_client
    if _tvm2_client is None:
        _tvm2_client = TvmClient(TvmApiClientSettings(
            self_client_id=TVM2["source"],
            self_secret=str(TVM2["secret"]),
            dsts=TVM2["targets"],
        ))
    return _tvm2_client
