# -*- coding: utf-8 -*-

from .yt import get_yt
from time import sleep
from logging import getLogger
from yql.api.v1.client import YqlClient
from drive.analytics.pybase.config import YT, YQL


def get_yql():
    """get_yql returns YQL client.
    """
    client = YqlClient(token=str(YQL["token"]), db=YT["proxy"])
    return client


def run_yql_query(query, yt=None, yql=None, logger=None):
    """run_yql_query runs YQL query using YQL and YT clients.
    """
    yt = yt or get_yt()
    yql = yql or get_yql()
    logger = logger or getLogger("pybase.yql")
    with yt.Transaction() as tx:
        query = (
            "PRAGMA yt.ExternalTx = '{}';\nPRAGMA yt.Pool = '{}';\n"
            .format(tx.transaction_id, YT["pool"]) + query
        )
        request = yql.query(query, syntax_version=1)
        request.run()
        # Sleep for one second.
        sleep(1)
        logger.info(request.share_url)
        results = request.get_results()
        if not results.is_success:
            logger.error(request.status)
            if results.errors:
                for error in results.errors:
                    logger.error(error)
            raise Exception(results.errors)
        return results
