# -*- coding: utf-8 -*-

from yt.wrapper.client import Yt
from drive.analytics.pybase.config import YT


def get_yt():
    """"get_yt returns YT client.
    """
    client = Yt(proxy=YT["proxy"], token=str(YT["token"]))
    client.config["remote_temp_tables_directory"] = YT["temp_path"]
    client.config["pool"] = YT["pool"]
    client.config["table_writer"] = {"max_row_weight": 128 * 1024 * 1024}
    client.config["user_job_spec_defaults"] = {
        "job_io": {"table_reader": {"max_row_weight": 128 * 1024 * 1024}},
    }
    return client


def yt_abspath(path):
    if path.startswith("//"):
        return path
    return YT["home_path"] + "/" + path.lstrip("/")
