# -*- coding: utf-8 -*-

from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker, scoped_session
from drive.analytics.pybase.config import DB_URL, DB_ECHO, DB_CONNECT_ARGS


Base = declarative_base()

engine = create_engine(
    DB_URL,
    echo=DB_ECHO,
    pool_recycle=300,
    pool_pre_ping=True,
    connect_args=DB_CONNECT_ARGS,
)

Session = sessionmaker(bind=engine)

# Session for multi-threaded usage
session = scoped_session(Session)
