# -*- coding: utf-8 -*-

from sqlalchemy import Column, DateTime, Date, JSON
from sqlalchemy.types import String, Integer, Text, BigInteger
from sqlalchemy.dialects import postgresql
from .db import Base


class LicenseCheck(Base):
    __tablename__ = "license_check_task"

    id = Column(BigInteger, primary_key=True)
    license_number = Column(String(255), nullable=False)
    license_issue_date = Column(Date(), nullable=False)
    result = Column(postgresql.JSONB(), nullable=False, default=JSON.NULL)
    raw_result = Column(Text, nullable=False, default="")
    check_retry = Column(Integer, nullable=False, default=0)
    check_next_time = Column(DateTime(timezone=True), nullable=True)
    notify_retry = Column(Integer, nullable=False, default=0)
    notify_next_time = Column(DateTime(timezone=True), nullable=True)
    callback = Column(String(32), nullable=False, default="")
    callback_data = Column(postgresql.JSONB(), nullable=False, default=JSON.NULL)
    result_time = Column(DateTime(timezone=True), nullable=True)
    priority = Column(Integer, nullable=False, default=10)
    check_tries = Column(Integer, nullable=False, default=5)
    callback_url = Column(String(255), nullable=True, default=None)
    # Deprecated.
    callback_id = Column(String(255), nullable=False, default="")
