# -*- coding: utf-8 -*-

from ipaddress import IPv4Address, AddressValueError
from sqlalchemy import Column, DateTime, Integer, String
from sqlalchemy.types import BigInteger, Text
from sqlalchemy.dialects import postgresql
from .db import Base


class YtRows(Base):
    __tablename__ = "yt_rows_queue"

    id = Column(BigInteger, primary_key=True)
    timestamp = Column(DateTime(), nullable=False)
    path = Column(Text, nullable=False)
    rows = Column(postgresql.JSONB(), nullable=True)


class Account(Base):
    __tablename__ = "thief_account"

    STATUS_ALIVE = "alive"
    STATUS_BROKEN = "broken"

    id = Column(BigInteger, primary_key=True)
    provider = Column(String(255), nullable=False)
    data = Column(postgresql.JSONB(), nullable=False)
    status = Column(String(255), nullable=False)


class Proxy(Base):
    __tablename__ = "thief_proxy"

    PROTOCOL_HTTP = "http"

    STATUS_ALIVE = "alive"
    STATUS_BROKEN = "broken"

    id = Column(BigInteger, primary_key=True)
    protocol = Column(String(255), nullable=False)
    ip_address = Column(String(255), nullable=False)
    port = Column(Integer, nullable=False)
    country = Column(String(255), nullable=False)
    status = Column(String(255), nullable=False)

    def __str__(self):
        return (
            "{}://{}:{}".
            format(self.protocol, self.nat64_ip_address, self.port)
        )

    @property
    def nat64_ip_address(self):
        try:
            IPv4Address(self.ip_address)
            return '{}.xip.io'.format(self.ip_address)
        except AddressValueError:
            return self.ip_address
