# -*- coding: utf-8 -*-

def register(cmd):
    from .orders_latest import orders_latest_main
    from .raw_routes import raw_routes_main
    from .routes import routes_main
    from .users_extended import users_extended_main
    from .insurance_tasks import insurance_tasks_main

    cmds = cmd.add_subparsers()
    cmds.required = True
    cmds.add_parser("orders-latest").set_defaults(func=orders_latest_main)
    cmds.add_parser("raw-routes").set_defaults(func=raw_routes_main)
    cmds.add_parser("users-extended").set_defaults(func=users_extended_main)
    cmds.add_parser("insurance-tasks").set_defaults(func=insurance_tasks_main)
    cmds.add_parser("routes").set_defaults(func=routes_main)
