# -*- coding: utf-8 -*-

from drive.analytics.pybase.helpers import get_solomon
from .orders_latest import run_yql_query_processed


def insurance_tasks_main(args):
    query = """
PRAGMA yt.InferSchema = "100";
PRAGMA yt.Owners = "iudovin";

$insurance_tasks_history = "//home/carsharing/production/db_dumps/insurance_tasks_history";
$start_date = CAST(CurrentUtcDate() - Interval("P3D") as String);

$tasks = 
SELECT 
    CAST(`history_timestamp` as Int64) as `history_timestamp`,
    `object_id` as `car_id`,
    `notification_id`,
    CAST(`start` as Int64) as `start`,
    CAST(`finish` as Int64) as `finish`,
    CAST(`history_timestamp` as Int64) - CAST(`finish` as Int64) as `lag`
FROM RANGE($insurance_tasks_history, $start_date)
WHERE `history_action` == "remove";

$start_intersections = 
SELECT 
    SUM(`duplicates`)
FROM (
    SELECT 
        `car_id`,
        `start`,
        COUNT(DISTINCT `notification_id`) as `duplicates`
    FROM $tasks
    GROUP BY `car_id`, `start`
)
WHERE `duplicates` > 1;

$finish_intersections =
SELECT 
    SUM(`duplicates`)
FROM (
    SELECT 
        `car_id`,
        `finish`,
        COUNT(DISTINCT `notification_id`) as `duplicates`
    FROM $tasks
    GROUP BY `car_id`, `finish`
)
WHERE `duplicates` > 1;

$zero_tasks = 
SELECT 
    COUNT(*)
FROM $tasks
WHERE `start` == `finish`;

$intersections = 
SELECT 
    COUNT(*)
FROM $tasks as l
INNER JOIN $tasks as r
ON l.`car_id` == r.`car_id`
WHERE l.`notification_id` != r.`notification_id`
    and ((r.`start` < l.`start` and l.`start` < r.`finish`)
        or (r.`start` < l.`finish` and l.`finish` < r.`finish`));

$lagging_tasks = 
SELECT
    `notification_id`,
    `lag`,
    CASE 
        WHEN `lag` > 300 and `lag` < 86400 THEN "lagging_task_(5m, 1d)"
        WHEN `lag` >= 86400 and `lag` < 3 * 86400 THEN "lagging_task_[1d, 3d)"
        WHEN `lag` >= 3 * 86400 and `lag` < 7 * 86400 THEN "lagging_task_[3d, 7d)"
        ELSE "lagging_task_[7d, ∞)"
    END as `type`
FROM $tasks
WHERE `lag` > 300;

SELECT 
    $start_intersections as `start_intersections`,
    $finish_intersections as `finish_intersections`,
    $zero_tasks as `zero_tasks`,
    $intersections as `intersections`,
    COUNT_IF(`lag` > 300 and `lag` < 86400) as `lagging_task_(5m, 1d)`,
    COUNT_IF(`lag` >= 86400 and `lag` < 3 * 86400) as `lagging_task_[1d, 3d)`,
    COUNT_IF(`lag` >= 3 * 86400 and `lag` < 7 * 86400) as `lagging_task_[3d, 7d)`,
    COUNT_IF(`lag` > 7 * 86400) as `lagging_task_[7d, ∞)`,
FROM $lagging_tasks; 
    """

    solomon = get_solomon("alerts")
    labels = {"table": "//home/carsharing/production/db_dumps/insurance_tasks_history"}
    try:
        row = run_yql_query_processed(query)[0][0]
        solomon.signal("lagging_task_(5m, 1d)", row["lagging_task_(5m, 1d)"], labels)
        solomon.signal("lagging_task_[1d, 3d)", row["lagging_task_[1d, 3d)"], labels)
        solomon.signal("lagging_task_[3d, 7d)", row["lagging_task_[3d, 7d)"], labels)
        solomon.signal("lagging_task_[7d, ∞)", row["lagging_task_[7d, ∞)"], labels)
        solomon.signal("start_intersections", row["start_intersections"], labels)
        solomon.signal("finish_intersections", row["finish_intersections"], labels)
        solomon.signal("zero_tasks", row["zero_tasks"], labels)
        solomon.signal("intersections", row["intersections"], labels)
    except Exception:
        solomon.signal("error", 1, labels)
        raise
