# -*- coding: utf-8 -*-

from time import time
from drive.analytics.pybase.helpers import get_solomon
from .orders_latest import run_yql_query_processed


def raw_routes_main(args):
    query = """
$table = "//home/carsharing/production/data/orders/raw_routes";
$row_count = SELECT COUNT(*) FROM $table;
SELECT
    $row_count AS rows_count,
    finish_timestamp AS max_time
FROM $table
LIMIT 1
OFFSET Unwrap(CAST($row_count AS Uint64)) - 1;
"""
    solomon = get_solomon("alerts")
    labels = {"table": "//home/carsharing/production/data/orders/raw_routes"}
    now = time()
    try:
        row = run_yql_query_processed(query)[0][0]
        solomon.signal("rows_count", row["rows_count"], labels)
        solomon.signal("data_lag", int(now - row["max_time"]), labels)
        solomon.signal("success", 1, labels)
    except Exception:
        solomon.signal("error", 1, labels)
        raise
