# -*- coding: utf-8 -*-

from time import time
from drive.analytics.pybase.helpers import get_solomon
from .orders_latest import run_yql_query_processed


def users_extended_main(args):
    query = """
SELECT
    COUNT(*) AS rows_count,
    max(register_time) AS max_time
FROM `//home/carsharing/production/data/user/extended`;
"""
    solomon = get_solomon("alerts")
    labels = {"table": "//home/carsharing/production/data/user/extended"}
    now = time()
    try:
        row = run_yql_query_processed(query)[0][0]
        solomon.signal("rows_count", row["rows_count"], labels)
        solomon.signal("data_lag", int(now - row["max_time"]), labels)
        solomon.signal("success", 1, labels)
    except Exception:
        solomon.signal("error", 1, labels)
        raise
