# -*- coding: utf-8 -*-

from datetime import timedelta
from drive.library.py.time import now, from_string


def register(cmd):
    from .closed_tags import closed_tags_main

    cmds = cmd.add_subparsers()
    cmds.required = True
    closed_tags_cmd = cmds.add_parser("closed-tags")
    closed_tags_cmd.set_defaults(func=closed_tags_main)
    last_date = from_string(now().strftime("%Y-%m-%d"), "%Y-%m-%d")
    closed_tags_cmd.add_argument(
        "--from-date",
        type=lambda v: from_string(v, "%Y-%m-%d"),
        default=last_date - timedelta(hours=48),
    )
    closed_tags_cmd.add_argument(
        "--to-date",
        type=lambda v: from_string(v, "%Y-%m-%d") + timedelta(hours=24),
        default=last_date,
    )
