# -*- coding: utf-8 -*-

def register(cmd):
    from .raw_routes import add_to_raw_routes_main, dump_raw_routes_main

    cmds = cmd.add_subparsers()
    cmds.required = True
    add_to_raw_routes = cmds.add_parser("add-to-raw-routes")
    add_to_raw_routes.set_defaults(func=add_to_raw_routes_main)
    add_to_raw_routes.add_argument("-s", "--session-id", nargs='+', required=True)
    dump_raw_routes = cmds.add_parser("dump-raw-routes")
    dump_raw_routes.set_defaults(func=dump_raw_routes_main)
    dump_raw_routes.add_argument("-p", "--path", required=True)
    dump_raw_routes.add_argument("-s", "--session-id", nargs='+', required=True)
