# -*- coding: utf-8 -*-

from yt.wrapper import TablePath
from drive.analytics.pybase.helpers import get_yt, get_drive
from drive.operations.orders.export_raw_routes import RawRouteExport


COMPILED_RIDES_TABLE = "//home/carsharing/production/data/exports/compiled_rides"
TABLE_PATH = "//home/carsharing/production/data/orders/raw_routes"
QUEUE_TABLE_PATH = TABLE_PATH + "_queue"


def dump_raw_routes_main(args):
    export = RawRouteExport(
        client=get_drive(),
        path=None,
        queue_path=None,
    )

    def get_raw_route(session_id):
        return export.transform({"session_id": session_id})

    yw = get_yt()
    yw.write_table(args.path, map(get_raw_route, args.session_id))


def add_to_raw_routes_main(args):
    sessions = set(args.session_id)

    def mapper(row):
        if row["session_id"] in sessions:
            yield row

    yw = get_yt()
    with yw.TempTable() as temp:
        compiled_rides = TablePath(
            COMPILED_RIDES_TABLE,
            columns=("history_event_id", "finish", "session_id"),
        )
        yw.run_map(mapper, compiled_rides, temp)
        new_rides = list(yw.read_table(temp))
    export = RawRouteExport(
        client=None,
        path=TABLE_PATH,
        queue_path=QUEUE_TABLE_PATH,
    )
    with yw.Transaction():
        yw.lock(TABLE_PATH)
        export.write(yw, new_rides)
