# -*- coding: utf-8 -*-

from argparse import ArgumentParser
from .alerts import register as register_alerts
from .fuelings import register as register_fuelings
from .knife import register as register_knife


def main():
    cmd = ArgumentParser()
    cmds = cmd.add_subparsers()
    cmds.required = True
    register_alerts(cmds.add_parser("alerts"))
    register_fuelings(cmds.add_parser("fuelings"))
    register_knife(cmds.add_parser("knife"))
    args = cmd.parse_args()
    args.func(args)
