# -*- coding: UTF-8 -*-

import json
import time
import os
import requests
import operator
from copy import deepcopy
from logging import getLogger
from drive.analytics.pybase.helpers import get_yt

DIR = '//home/carsharing/production/car/'
DIR_ORDERS = '//home/carsharing/production/orders/'
DIR_USER_ROLES = '//home/carsharing/production/user_roles_history'
CARS_ATTR = '//home/carsharing/production/car/cars_attr'

_log = getLogger(__name__)
yt = get_yt()


def get_spb_cars():
	_log.info("fetching spb cars")
	headers = {"Authorization": config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	value = ''
	for i in range(3):
		try:
			responce = requests.get(config_auth['car_from_spb'], headers=headers)
			if responce.status_code == 200:
				try:
					value = json.loads(responce.content)
					break
				except:
					pass
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	value = {car['id'] for car in value['cars']}
	if value:
		return value
	else:
		value = set()
		rows = yt.read_table(CARS_ATTR)
		for row in rows:
			if 'tags' not in row:
				continue
			if row['tags']:
				if 'spb_area' in row['tags']:
					value.add(row['car_id'])
		return value

def get_kzn_cars():
	_log.info("fetching kzn cars")
	headers = {"Authorization":config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	value = ''
	for i in range(3):
		try:
			responce = requests.get(config_auth['car_from_kzn'], headers=headers)
			if responce.status_code == 200:
				try:
					value = json.loads(responce.content)
					break
				except:
					pass
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	value = {car['id'] for car in value['cars']}
	if value:
		return value
	else:
		value = set()
		rows = yt.read_table(CARS_ATTR)
		for row in rows:
			if 'tags' not in row:
				continue
			if row['tags']:
				if 'kazan_area' in row['tags']:
					value.add(row['car_id'])
		return value

def get_sch_cars():
	_log.info("fetching sch cars")
	headers = {"Authorization":config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	value = ''
	for i in range(3):
		try:
			responce = requests.get(config_auth['car_from_sch'], headers=headers, verify=False)
			if responce.status_code == 200:
				try:
					value = json.loads(responce.content)
					break
				except:
					pass
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	value = {car['id'] for car in value['cars']}
	if value:
		return value
	else:
		value = set()
		rows = yt.read_table(CARS_ATTR)
		for row in rows:
			if 'tags' not in row:
				continue
			if row['tags']:
				if 'sochi_area' in row['tags']:
					value.add(row['car_id'])
		return value

def get_first_order():
	_log.info("building first order")
	Tables = yt.list(DIR_ORDERS[:-1], max_size=100000, format=None, absolute=True, attributes=None)

	def mapper(row):
		if row['completed_at'] is None:
			return
		if float(row['cost']['value']) == 0:
			return
		car_id = row['items'][0]['params']['car']['id']
		created_at = row['created_at']
		yield {'car_id':car_id, 'created_at':int(created_at)}

	yt.run_map(
		mapper,
		Tables,
		DIR+'first_order')

	yt.run_sort(DIR+'first_order', sort_by = ['car_id', 'created_at'])

	def reducer(key, rows):
		timing = []
		for row in rows:
			if len(timing) < 3:
				timing.append(row)
			else:
				timing[-1] = row
		if timing:
			yield {
				'car_id':row['car_id'],
				'first_order':timing[0]['created_at'],
				'last_order':timing[-1]['created_at']}

	yt.run_reduce(
		reducer,
		DIR+'first_order',
		DIR+'first_order',
		sort_by = ['car_id', 'created_at'],
		reduce_by = ['car_id'])

def get_role():

	Tables = yt.list(DIR_USER_ROLES, max_size=100000, format=None, absolute=True, attributes=None)

	def mapper(row):
		if row['role_id'] in ['installator_Major', 'installator_vega', 'tester_auto', 'manager_auto', 'tech_support', 'GR_installator_47_Vega']:
			yield {'user_id':row['user_id'], 'role_id':row['role_id']}

	yt.run_map(
		mapper,
		Tables,
		DIR+'user_role_tmp')

def get_cars_attr(filters, filters_set):
	_log.info("fetching car attributes")
	spb_cars = get_spb_cars()
	kzn_cars = get_kzn_cars()
	sch_cars = get_sch_cars()

	headers = {"Authorization":config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	value = ''
	for i in range(3):
		try:
			resp = requests.get(
				config_auth['status_car_new_back']+'sensors=fuel_level,fuel_distance,mileage&traits=ReportIMEI,ReportVIN,ReportLocationDetails,ReportTagDetails,ReportDocuments',
				headers=headers,
			)
			resp.raise_for_status()
			value = resp.json()
			break
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	cars = {}
	models = value['models']

	if value:
		for car in value['cars']:
			cars_id = car['id']
			number = car['number']
			model = car['model_id']
			segment = models[model].get('segment')
			vin = car['vin']
			city = 'MSK'
			if cars_id in spb_cars:
				city = 'SPB'
			if cars_id in kzn_cars:
				city = 'KZN'
			if cars_id in sch_cars:
				city = 'SCH'
			imei = car['imei']
			car_id = car['id']
			tags = car.get('location')
			car_tags = car["tags"]
			mileage = 0
			if car.get('telematics'):
				if car['telematics'].get('mileage'):
					mileage = int(car['telematics'].get('mileage'))
			if tags:
				tags = tags.get('tags')
			car_filters = set()
			for filter in filters:
				conditions = filter["action_meta"].get("conditions", "").split(",")
				action_id = filter["action_id"]
				for tag in car_tags:
					if tag["tag"] in conditions and "-" + tag["tag"] not in conditions:
						car_filters.update(filters_set[action_id])
			attr = {
				'number':number,
				'model':model,
				'segment':segment,
				'vin':vin,
				'city':city,
				'imei':imei,
				'car_id':car_id,
				'tags':tags,
				'car_tags': car_tags,
				'mileage':mileage,
				'lessor': car.get("lessor"),
				'filters': list(car_filters),
			}
			cars[car_id] = attr
		return cars


def get_actions():
	url = "https://prestable.carsharing.yandex.net/api/staff/actions/list"
	headers = {"Authorization": config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	response = requests.get(url, headers=headers)
	response.raise_for_status()
	return response.json()


def requester(id):
	url = config_auth['attachments_history'].replace("http:", "https:")
	headers = {"Authorization": config_auth['carsharing_token_new_back'], "Content-Type":"application/json", 'AppBuild': '100000'}
	value = {}
	for i in range(3):
		try:
			resp = requests.get(url%id, headers=headers)
			resp.raise_for_status()
			value = json.loads(resp.content)
			break
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	if value:
		return value

def get_head_id(id, roles):

	def get_data(id):
		full_imei_list = []
		imei_list = []
		head_id_list = []
		beacon_list = []
		modem_list = []
		parking_permit_list = set()
		transfer_date_list = set()
		agreement_number_list = set()
		agreement_partner_number_list = set()
		car_insurance_attr = []
		transponder_list = []
		airport_list = []
		base_data_list = []
		value = requester(id)
		if value is None:
			return (
				list(parking_permit_list),
				imei_list,
				head_id_list,
				beacon_list,
				modem_list,
				list(transfer_date_list),
				list(agreement_number_list),
				list(agreement_partner_number_list),
				car_insurance_attr,
				transponder_list,
				airport_list,
				base_data_list)

		attachments = {}
		map = {}

		for item in value['attachments']:
			if item['data'] is None:
				continue
			attachments[item['id']] = item['data']
			attachments[item['id']]['type'] = item['type']

		for item in value['history']:
			attachment_id = item['object']['generic_attachment_id']
			timeatamp = item['timestamp']
			user_id = item['user_id']
			action = item['action']
			if attachment_id in attachments:
				attachments[attachment_id][action] = timeatamp
				attachments[attachment_id]['user_id'] = None
				if action == 'add':
					attachments[attachment_id]['user_id'] = user_id
					map[attachment_id] = timeatamp

		map = sorted(map.items(), key=operator.itemgetter(1))

		for item in map:
			data = attachments[item[0]]
			type = data['type']
			user_id = data['user_id']
			username = ''
			role_id = roles.get(user_id)
			if role_id:
				username = role_id[1]
				role_id = role_id[0]

			base_data = {
					'add':None,
					'remove':None,
					'username':username,
					'role_id':role_id}

			if type == u'Вега':
				imei = data['imei']
				if imei != 'None' and imei not in full_imei_list:
					full_imei_list.append(imei)

			if type == u'Вега':
				update_data = deepcopy(base_data)
				update_data.update(data)
				imei_list.append(update_data)

			if type == u'Голова':
				update_data = deepcopy(base_data)
				update_data.update(data)
				head_id_list.append(update_data)

			if type == u'Маяк':
				update_data = deepcopy(base_data)
				update_data.update(data)
				beacon_list.append(update_data)

			if type == u'Модем':
				update_data = deepcopy(base_data)
				update_data.update(data)
				modem_list.append(update_data)

			if type == u'Страховой полис':
				agreement_number = data.get('agreement_number')
				agreement_partner_number = data.get('agreement_partner_number')
				valid_until = data.get('valid_until')
				valid_from = data.get('valid_from')
				base_cost = data['base_cost']
				per_minute_cost = data['per_minute_cost']
				car_insurance_attr.append({
					'agreement_number':agreement_number,
					'agreement_partner_number':agreement_partner_number,
					'provider': data.get('provider'),
					'valid_until':valid_until,
					'valid_from':valid_from,
					'base_cost':base_cost,
					'per_minute_cost':per_minute_cost,
					'add':data.get('add'),
					'remove':data.get('remove'),
					'username':username,
					'role_id':role_id})
				agreement_number_list.add(agreement_number)
				agreement_partner_number_list.add(agreement_partner_number)

			if type == u'Базовые данные об авто':
				parking_permit_start_date = data.get('parking_permit_start_date')
				if parking_permit_start_date:
					parking_permit_list.add(parking_permit_start_date)
				transfer_date = data.get('transfer_date')
				if transfer_date:
					transfer_date_list.add(transfer_date)

			if type == u'Транспондер (СПб)':
				transponder_list.append({
					'code':data['code'],
					'add':data.get('add'),
					'remove':data.get('remove'),
					'username':username,
					'role_id':role_id})

			if type == u'Метка-пропуск в Пулково (СПб)':
				update_data = deepcopy(base_data)
				update_data.update(data)
				airport_list.append(update_data)

			if type == u'Базовые данные об авто':
				update_data = deepcopy(base_data)
				update_data.update(data)
				base_data_list.append(update_data)

		return (
			list(parking_permit_list),
			imei_list,
			head_id_list,
			beacon_list,
			modem_list,
			list(transfer_date_list),
			list(agreement_number_list),
			list(agreement_partner_number_list),
			car_insurance_attr,
			transponder_list,
			airport_list,
			base_data_list)

	return get_data(id)


def get_username(id):
	headers = {"Authorization":config_auth['carsharing_token'], "Content-Type":"application/json"}
	for i in range(5):
		try:
			resp = requests.get(config_auth['base_url']['carsharing']+"/api/admin/v1/users/%s/"% id, headers=headers)
			resp.raise_for_status()
			return resp.json()
		except Exception as exc:
			_log.exception(exc)
			time.sleep(5 + i * 30)
	return {}


def main():
	_log.info("build filters set")
	filters = list()
	filters_set = dict()
	for action in get_actions()["report"]:
		if action.get("action_type") != "filter":
			continue
		filters.append(action)
		filters_set[action["action_id"]] = set()
	# Make dependency grap.
	for filter in filters:
		action_id = filter["action_id"]
		parents = filter["action_meta"].get("parent_objects") or ()
		filters_set[action_id].add(action_id)
		for parent in parents:
			filters_set[action_id].add(parent)
	# Run DFS.
	filters_visited = set()

	def filter_dfs(filter_a):
		filters_visited.add(filter_a)
		edges = tuple(filters_set[filter_a])
		for filter_b in edges:
			if filter_b not in filters_visited:
				filter_dfs(filter_b)
			filters_set[filter_a].update(filters_set[filter_b])

	for filter in filters_set:
		if filter in filters_visited:
			continue
		filter_dfs(filter)
	get_first_order()
	get_role()
	cars = get_cars_attr(filters, filters_set)
	source = []
	rows = yt.read_table(DIR+'first_order')
	orders = {row['car_id']:{'first_order':row['first_order'], 'last_order':row['last_order']} for row in rows}
	rows = yt.read_table(DIR+'user_role_tmp')
	roles = {row['user_id']:row['role_id'] for row in rows}
	roles = {id:(roles[id], get_username(id)['username']) for id in roles}
	for id in cars:
		value = {
			'imei':None,
			'add':None,
			'remove':None,
			'username':None,
			'role_id':None}
		report = get_head_id(id, roles)
		parking_permit_start_date = report[0]
		imei = report[1]
		head_id = report[2]
		beacon = report[3]
		modem = report[4]
		transfer_date = report[5]
		agreement_number = report[6]
		agreement_partner_number = report[7]
		car_insurance_attr = report[8]
		transponder = report[9]
		airport = report[10]
		base_data = report[11]
		row = cars[id]
		row['parking_permit_start_date'] = parking_permit_start_date
		if imei:
			row['imei'] = imei
		else:
			value['imei'] = row['imei']
			row['imei'] = [value]
		row['head_id'] = head_id
		row['beacon'] = beacon
		row['modem'] = modem
		row['transfer_date'] = transfer_date
		row['agreement_number'] = agreement_number
		row['agreement_partner_number'] = agreement_partner_number
		row['car_insurance_attr'] = car_insurance_attr
		row['transponder'] = transponder
		row['airport'] = airport
		row['base_data'] = base_data
		row['first_order'] = None
		row['last_order'] = None
		timing = orders.get(id)
		if timing:
			row['first_order'] = timing['first_order']
			row['last_order'] = timing['last_order']
		source.append(row)

	last_date = []
	for raw_data in source:
		row = deepcopy(raw_data)
		filds = row.keys()
		for fild in filds:
			if fild == 'tags':
				continue
			if type(row[fild]) == type([]):
				if row[fild]:
					row[fild] = [row[fild][-1]]
		if row['car_insurance_attr']:
			row['agreement_number'] = row['car_insurance_attr'][-1]['agreement_number']
			row['agreement_partner_number'] = row['car_insurance_attr'][-1]['agreement_partner_number']
		if row['base_data']:
			row['parking_permit_start_date'] = row['base_data'][-1].get('parking_permit_start_date')
			row['transfer_date'] = row['base_data'][-1].get('transfer_date')
		last_date.append(row)
		del raw_data['base_data']

	simple_date = []
	for row in last_date:
		vega = {}
		beacon = {}
		modem = {}
		imei = ''
		vega_icc1 = ''
		vega_icc2 = ''
		car_hardware_beacon = ''
		beacon_icc = ''
		car_hardware_modem = ''
		car_hardware_head = ''
		car_transponder_spb = ''
		car_airport_pass_spb = ''
		if row['imei']:
			if row['imei'][0]:
				vega = row['imei'][0]
		if vega.get('imei'):
			imei = vega.get('imei')
		if vega.get('primary_sim'):
			if vega['primary_sim'].get('icc'):
				vega_icc1 = vega['primary_sim'].get('icc')
			if vega['secondary_sim'].get('icc'):
				vega_icc2 = vega['secondary_sim'].get('icc')
		if row['beacon']:
			if row['beacon'][0]:
				beacon = row['beacon'][0]
		if beacon.get('imei'):
			car_hardware_beacon = beacon.get('imei')
		if beacon.get('sim'):
			if beacon['sim']:
				if beacon['sim'].get('icc'):
					beacon_icc = beacon['sim'].get('icc')
		if row['modem']:
			if row['modem'][0]:
				modem = row['modem'][0]
		if modem.get('sim'):
			if modem['sim'].get('icc'):
				car_hardware_modem = modem['sim'].get('icc')
		if row['head_id']:
			if row['head_id'][0]:
				if row['head_id'][0].get('head_id'):
					car_hardware_head = row['head_id'][0].get('head_id')
		if row['transponder']:
			if row['transponder'][0]:
				if row['transponder'][0].get('code'):
					car_transponder_spb = row['transponder'][0].get('code')
		if row['airport']:
			if row['airport'][0]:
				if row['airport'][0].get('code'):
					car_airport_pass_spb = row['airport'][0].get('code')

		new_row = {
			'vin':row['vin'],
			'city':row['city'],
			'number':row['number'],
			'model':row['model'],
			'car_hardware_vega':imei,
			'vega_icc1':vega_icc1,
			'vega_icc2':vega_icc2,
			'vega_modification':'',
			'car_hardware_beacon':car_hardware_beacon,
			'beacon_icc':beacon_icc,
			'car_hardware_modem':car_hardware_modem,
			'car_hardware_head':car_hardware_head,
			'car_transponder_spb':car_transponder_spb,
			'car_airport_pass_spb':car_airport_pass_spb}

		simple_date.append(new_row)

	yt.write_table(DIR+'cars_attr', source)

	schema = [
		{"name":"agreement_number", "type":"any"},
		{"name":"agreement_partner_number", "type":"any"},
		{"name":"beacon", "type":"any"},
		{"name":"car_id", "type":"string"},
		{"name":"car_insurance_attr", "type":"any"},
		{"name":"first_order", "type":"int64"},
		{"name":"last_order", "type":"int64"},
		{"name":"head_id", "type":"any"},
		{"name":"imei", "type":"any"},
		{"name":"mileage", "type":"int64"},
		{"name":"model", "type":"string"},
		{"name":"modem", "type":"any"},
		{"name":"number", "type":"string"},
		{"name":"parking_permit_start_date", "type":"any"},
		{"name":"tags", "type":"any"},
		{"name":"transfer_date", "type":"any"},
		{"name":"transponder", "type":"any"},
		{'name':'airport', 'type':'any'},
		{"name":"vin", "type":"string"},
		{"name":"city", "type":"string"},
		{"name":"segment", "type":"string"},
		{"name": "car_tags", "type": "any"},
		{"name": "filters", "type": "any"},
		{"name": "lessor", "type": "string"},
	]

	yt.create('table', '//home/carsharing/production/data/cars/cars_attr', recursive = True, ignore_existing = True, attributes={"schema": schema})
	yt.write_table('//home/carsharing/production/data/cars/cars_attr', source)

	yt.write_table('//home/carsharing/production/data/cars/cars_attr_simple', simple_date)

	source = [{'car_id':row['car_id'], 'number':row['number'], 'model':row['model'], 'head_id':row['head_id'], 'city':row['city'], 'imei':row['imei']} for row in source]
	yt.write_table('//home/carsharing/production/export/auto/cars_attr', source)

	if yt.exists('//home/carsharing/production/export/fin'):
		yt.write_table('//home/carsharing/production/export/fin/cars_attr_last', last_date)

if __name__ == '__main__':
	config_auth = {
		"carsharing_token_new_back": "OAuth " + os.environ["DRIVE_OAUTH_TOKEN"],
        "carsharing_token": "OAuth " + os.environ["DRIVE_OAUTH_TOKEN"],
		"status_car_new_back": "https://prestable.carsharing.yandex.net/api/staff/car/list?",
		"car_from_spb": "https://prestable.carsharing.yandex.net/api/staff/car/list?tags_filter=peterburg_tag",
		"car_from_kzn": "https://prestable.carsharing.yandex.net/api/staff/car/list?tags_filter=kazan_tag",
		"car_from_sch": "https://prestable.carsharing.yandex.net/api/staff/car/list?tags_filter=sochi_tag",
		"attachments_history": "http://prestable.carsharing.yandex.net/api/staff/car/attachments/history?car_id=%s",
		"base_url": {"carsharing": "https://carsharing.yandex-team.ru"},
	}
	main()
