#include "frontend.h"

#include <library/cpp/logger/global/global.h>

class TServerInstance {
private:
    const IServerBase* Server = nullptr;

public:
    bool HasServer() const {
        return Server;
    }

    void SetServer(const IServerBase* server);

    const IServerBase& GetServer() const;
};

bool NDrive::HasServer() {
    return Singleton<TServerInstance>()->HasServer();
}

const IServerBase& NDrive::GetServer() {
    return Singleton<TServerInstance>()->GetServer();
}

void NDrive::RegisterServer(const IServerBase& server) {
    Singleton<TServerInstance>()->SetServer(&server);
}

void NDrive::DeregisterServer() {
    Singleton<TServerInstance>()->SetServer(nullptr);
}

IServerBase::IServerBase() {
    NDrive::RegisterServer(*this);
}

IServerBase::~IServerBase() {
    NDrive::DeregisterServer();
}

void TServerInstance::SetServer(const IServerBase* server) {
    CHECK_WITH_LOG((Server == nullptr) != (server == nullptr));
    Server = server;
}

const IServerBase& TServerInstance::GetServer() const {
    Y_ENSURE_BT(Server);
    return *Server;
}
