#pragma once

#include <rtline/library/storage/structured.h>

class IDriveTagsManager;
class IReplyContext;
class TAreasDB;
class TSessionManager;
class TAdditionalServiceSessionManager;
class TDedicatedFleetSessionManager;
class TCarAttachmentAssignmentDB;
class TCarNumbersDB;
class TCarsDB;
class TDBImei;
class TDBVin;
class TGeoCoord;
class TImagesStorage;
class TLandingAcceptanceDB;
class TLandingsDB;
class TMajorClient;
class TMinimalRidingHistoryManager;
class TModelsDB;
class TRolesManager;
class TStateFiltersDB;
class TUsersDB;
class TUserPermissions;
class TUserPermissionsFeatures;
class TDatasyncQueueClient;

using TReplyContextPtr = TAtomicSharedPtr<IReplyContext>;
using TUserPermissionsPtr = TIntrusiveConstPtr<TUserPermissions>;
using TUserPermissionsConstPtr = TUserPermissionsPtr;

namespace NDrive {
    class TEntitySession;
}

class IDriveDatabase {
public:
    virtual TUsersDB* GetUsersData() const = 0;

    virtual TLandingsDB* GetLandingsDB() const = 0;
    virtual TLandingAcceptanceDB* GetUserLandingData() const = 0;

    virtual TCarNumbersDB* GetCarNumbers() const = 0;
    virtual TDBImei* GetCarsImei() const = 0;
    virtual TDBVin* GetCarVins() const = 0;
    virtual TModelsDB& GetModelsDB() const = 0;
    virtual TStateFiltersDB* GetStateFiltersDB() const = 0;

    virtual const TAreasDB& GetAreaManager() const = 0;
    virtual const TCarsDB& GetCarManager() const = 0;
    virtual const TCarAttachmentAssignmentDB& GetCarAttachmentAssignments() const = 0;
    virtual const TDatasyncQueueClient* GetDatasyncQueueClient() const = 0;
    virtual const TImagesStorage& GetImageStorage() const = 0;
    virtual const TLandingsDB& GetLandingManager() const = 0;
    virtual const TMajorClient& GetMajorClient() const = 0;
    virtual const TSessionManager& GetSessionManager() const = 0;
    virtual const TAdditionalServiceSessionManager& GetAdditionalServiceSessionManager() const = 0;
    virtual const TDedicatedFleetSessionManager& GetDedicatedFleetSessionManager() const = 0;
    virtual const TMinimalRidingHistoryManager& GetCompiledSessionManager() const = 0;
    virtual const IDriveTagsManager& GetTagsManager() const = 0;
    virtual const TUsersDB& GetUserManager() const = 0;
    virtual const TRolesManager& GetUserPermissionManager() const = 0;
    virtual TUserPermissionsPtr GetUserPermissions(
        const TString& userId,
        const TUserPermissionsFeatures& userFeatures = Default<TUserPermissionsFeatures>(),
        TInstant reqActuality = TInstant::Zero(),
        TReplyContextPtr context = nullptr,
        bool addCustomActions = true,
        bool useCache = false,
        bool forceFetchPermissions = false
    ) const = 0;

    virtual TMap<TString, TGeoCoord> GetObjectFuturePositions() const = 0;
};
