#pragma once

#include "base.h"
#include "drive_database.h"

class IChatRobot;
template <class TObjectContainer>
class IDBEntitiesWithPropositionsManager;
class IDistributingBlockEventsStorage;
class IOffersStorage;
class IPromoCodesManager;
class ISupportCenterManager;
class ITagsMeta;
class ITaxiChatClient;
class ITaxiSignalqDrivematicsApiClient;
class IUserRegistrationManager;
class IUsersController;

class TAccountEmailBinder;
class TArea;
class TBalanceClient;
class TChatRobotConfig;
class TChatRobotStatePostgresStorage;
class TChatRobotsManager;
class TChatViewTracker;
class TClearWebClient;
class TDevicesSnapshotManager;
class TDocumentsManager;
class TDriveAPI;
class TFuelingManager;
class TRTFactorsConstructor;
class TRadarGeohashManager;
class TSelfHttpRequester;
class TSendrClient;
class TSimpleTaxiClient;
class TSimpleUnencryptedMediaStorage;
class TSocialAPIClient;
class TTaxiAntifraudClient;
class TTaxiDriverProfilesClient;
class TTaxiDriverStatusClient;
class TTaxiFleetVehiclesClient;
class TTaxiSupportChatSuggestClient;
class TTaxiSupportClassifierClient;
class TUserDocumentsChecksManager;
class TWeatherAPI;
class TYaDocClient;
class TYangClient;
class TDatabaseSessionConstructor;
class TTaxiTrackStoryClient;

enum class EPassApiType;

namespace NDrive {
    class IRouter;
    class ISensorApi;
    class ISensorHistoryApi;
    class ISensorHistoryClient;
    class TClickHouseBackendClient;
    class ITrackClient;
    class TGeoFeaturesClient;
    class TMapsLinker;
    class TModelsStorage;
    class TParkingZonesManager;
    class TTaxiRouteHistoryClient;
    class TTaxiSuggestClient;
    class TTaxiSupportClassifierClient;
    class TTaxiSurgeCalculator;
    class TRtmrSurgeClient;
    class TTelematicsApi;
    class TTelematicsClient;
    class TUserEventsApi;
    class TVehicleRouter;
    class TSaturnClient;
    class TScooterRouter;
    class TParkingAggregatorsManager;
    class TPedestrianRouter;
    class TSupportAIClient;
}

namespace NGeobase {
    class TLookup;
}

namespace NGraph {
    class ILinker;
}

namespace NDrive::NChat {
    class TEngine;
}

namespace NDrive::NRenins {
    namespace NKasko {
        class TClient;
    }
}

namespace NDrive {

class IServer: public virtual IServerBase {
public:
    virtual const NDrive::NChat::TEngine* GetChatEngine() const = 0;
    virtual IUsersController* GetUsersController() const = 0;
    virtual const NDrive::TTaxiSuggestClient* GetTaxiSuggest() const = 0;
    virtual const NDrive::TTaxiSupportClassifierClient* GetTaxiSupportClassifier() const = 0;
    virtual const IDriveDatabase& GetDriveDatabase() const = 0;
    virtual const TDriveAPI* GetDriveAPI() const = 0;
    virtual const TFuelingManager* GetFuelingManager() const = 0;
    virtual NDrive::TModelsStorage* GetModelsStorage() const = 0;
    virtual const TDevicesSnapshotManager& GetSnapshotsManager() const = 0;
    virtual TAtomicSharedPtr<TRTFactorsConstructor> GetSurgeConstructor() const = 0;
    virtual const NDrive::TTelematicsApi& GetTelematicsApi() const = 0;
    virtual const NDrive::TTelematicsClient& GetTelematicsClient() const = 0;
    virtual const NDrive::ISensorApi* GetSensorApi() const = 0;
    virtual const NDrive::ISensorHistoryApi* GetSensorHistoryApi() const = 0;
    virtual const NDrive::ISensorHistoryClient* GetSensorHistoryClient() const = 0;
    virtual const NDrive::TClickHouseBackendClient* GetRidesInfoClient() const = 0;
    virtual const NDrive::ITrackClient* GetTrackClient() const = 0;
    virtual const TWeatherAPI* GetWeatherAPI() const = 0;
    virtual const IUserRegistrationManager* GetUserRegistrationManager() const = 0;
    virtual TSet<TString> GetFullAreaTagsList() const = 0;
    virtual const NGeobase::TLookup* GetGeobase() const = 0;
    // TODO(iudovin@): Merge GeoFeaturesClient with FeaturesClient.
    virtual const NDrive::TGeoFeaturesClient* GetGeoFeaturesClient() const = 0;
    virtual TMaybe<NDrive::TGeoFeaturesClient> GetGeoFeaturesClient(const TString& name) const = 0;
    virtual const NDrive::TUserEventsApi* GetUserEventsApi() const = 0;
    virtual const NDrive::TUserEventsApi* GetFeaturesClient() const = 0;
    virtual const IPromoCodesManager* GetPromoCodesManager() const = 0;
    virtual const TClearWebClient* GetClearWebClient() const = 0;
    virtual const IDBEntitiesWithPropositionsManager<TArea>* GetAreasManager() const = 0;
    virtual const NDrive::TParkingZonesManager& GetParkingZonesManager() const = 0;
    virtual const TAtomicSharedPtr<IChatRobot> GetChatRobot(const TString& name) const = 0;
    virtual const TChatRobotsManager* GetChatRobotsManager() const = 0;
    virtual TMap<TString, TAtomicSharedPtr<IChatRobot>> GetChatRobots() const = 0;
    virtual bool RegisterChatRobot(const TChatRobotConfig& config) const = 0;
    virtual bool UnregisterChatRobot(const TString& robotId) const = 0;
    virtual const ISupportCenterManager* GetSupportCenterManager() const = 0;
    virtual const TSocialAPIClient* GetSocialAPIClient() const = 0;
    virtual const TAccountEmailBinder* GetAccountEmailBinder() const = 0;
    virtual const TBalanceClient* GetBalanceClient() const = 0;
    virtual const TYaDocClient* GetYaDocClient() const = 0;
    virtual IOffersStorage* GetOffersStorage() const = 0;
    virtual const TSelfHttpRequester* GetSelfHttpRequester() const = 0;
    virtual const TDocumentsManager* GetDocumentsManager() const = 0;
    virtual TAtomicSharedPtr<NGraph::ILinker> GetLinker(const TString& name) const = 0;
    virtual TAtomicSharedPtr<NDrive::TMapsLinker> GetMapsLinker() const = 0;
    virtual const NDrive::IRouter* GetMapsRouter() const = 0;
    virtual const NDrive::TPedestrianRouter* GetPedestrianRouter() const = 0;

    virtual const TCovidPassClient* GetCovidPassClient(EPassApiType apiType) const = 0;
    virtual const TTaxiAntifraudClient* GetTaxiAntifraudClient() const = 0;
    virtual const TTaxiDriverProfilesClient* GetTaxiDriverProfilesClient() const = 0;
    virtual const TTaxiDriverStatusClient* GetTaxiDriverStatusClient() const = 0;
    virtual const TTaxiFleetVehiclesClient* GetTaxiFleetVehiclesClient() const = 0;
    virtual const ITaxiChatClient* GetTaxiChatClient() const = 0;
    virtual const TSimpleTaxiClient* GetTaxiRouteInfoClient() const = 0;
    virtual const NDrive::TTaxiSurgeCalculator* GetTaxiSurgeCalculator() const = 0;
    virtual const NDrive::TTaxiRouteHistoryClient* GetTaxiRouteHistoryClient() const = 0;
    virtual const ITaxiSignalqDrivematicsApiClient* GetTaxiSignalqDrivematicsApiClient() const = 0;
    virtual const IDistributingBlockEventsStorage* GetDistributingBlockEventsStorage() const = 0;
    virtual const TTaxiSupportChatSuggestClient* GetTaxiSupportChatSuggestClient() const = 0;
    virtual const TSendrClient* GetSendrClient() const = 0;
    virtual const TUserDocumentsChecksManager* GetUserDocumentsChecksManager() const = 0;
    virtual const TRadarGeohashManager* GetRadarGeohashManager() const = 0;
    virtual const NDrive::TSaturnClient* GetSaturnClient() const = 0;
    virtual const TDatabaseSessionConstructor* GetYDB() const = 0;
    virtual const NDrive::TParkingAggregatorsManager* GetParkingManager() const = 0;
    virtual const NDrive::TRtmrSurgeClient* GetRtmrClient() const = 0;
    virtual const TTaxiTrackStoryClient* GetTaxiTrackStoryClient() const = 0;
    virtual const NDrive::TSupportAIClient* GetSupportAIClient() const = 0;
    virtual const TYangClient* GetYangClient() const = 0;
    virtual const NDrive::NRenins::NKasko::TClient* GetReninsKaskoClient() const = 0;
    virtual NDrive::TTaxiPromocodesClient* GetTaxiPromocodesClient() const = 0;
};

} // namespace NDrive
