#pragma once

#include <rtline/library/storage/structured.h>

class IHistoryContext;

class TSetting {
public:
    R_FIELD(TString, Key);
    R_FIELD(TString, Value);

    R_FIELD(ui64, Revision, Max<ui64>());

public:
    class TSettingDecoder: public TBaseDecoder {
    public:
        R_FIELD(i32, Key, -1);
        R_FIELD(i32, Value, -1);
        R_FIELD(i32, Revision, -1);

    public:
        TSettingDecoder() = default;
        TSettingDecoder(const TMap<TString, ui32>& decoderBase);
    };
    using TDecoder = TSettingDecoder;

    explicit operator bool() const {
        return !GetKey().empty();
    }

    using TId = TString;

    bool HasRevision() const {
        return Revision != Max<ui64>();
    }

    TMaybe<ui64> OptionalRevision() const {
        return HasRevision() ? Revision : TMaybe<ui64>();
    }

    static TString GetTableName() {
        return "drive_settings";
    }

    static TString GetPropositionsTableName() {
        return GetTableName() + "_propositions";
    }

    static TString GetHistoryTableName() {
        return GetTableName() + "_history";
    }

    const TString& GetInternalId() const {
        return GetKey();
    }

public:
    TSetting() = default;
    TSetting(const TString& key, const TString& value)
        : Key(key)
        , Value(value)
    {
    }

    bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);
    NJson::TJsonValue SerializeToJson() const;

    bool DeserializeWithDecoder(const TSettingDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    bool Parse(const NStorage::TTableRecord& record);

    bool DeserializeFromTableRecord(const NStorage::TTableRecord& record, const IHistoryContext* /*context*/);
    NStorage::TTableRecord SerializeToTableRecord() const;
    NStorage::TTableRecord SerializeUniqueToTableRecord() const;

    NJson::TJsonValue BuildJsonReport() const;
};
