#include "settings.h"

#include <library/cpp/json/json_reader.h>

#include <rtline/util/types/interval.h>

bool NDrive::ISettings::GetIntervalParamValueJsonDef(const TString& prefix, const int value, const NJson::TJsonValue& defaultValue, NJson::TJsonValue& result, const TInstant reqActuality /*= TInstant::Zero()*/) const {
    TVector<TSetting> settings;
    if (!GetAllSettings(settings, reqActuality)) {
        return false;
    }
    TMaybe<TString> resultValueStr;
    for (auto&& i : settings) {
        if (i.GetKey().StartsWith(prefix)) {
            const TString intervalStr = i.GetKey().substr(prefix.size() + 1);
            if (intervalStr == "default") {
                resultValueStr = i.GetValue();
                continue;
            }
            auto optionalInterval = TryParseInterval<int>(intervalStr, ',');
            if (!optionalInterval) {
                continue;
            }
            if (optionalInterval->CheckLeftBorder(value)) {
                resultValueStr = i.GetValue();
                break;
            }
        }
    }
    if (!resultValueStr) {
        result = defaultValue;
    } else {
        NJson::TJsonValue jsonResult;
        if (!NJson::ReadJsonFastTree(*resultValueStr, &jsonResult)) {
            result = *resultValueStr;
        } else {
            result = jsonResult;
        }
    }
    return true;
}

NJson::TJsonValue NDrive::ISettingGetter::GetJsonValue(TStringBuf key, bool throwOnParseError) const {
    TString resultStr;
    NJson::TJsonValue resultJson;
    if (!GetValueStr(key, resultStr)) {
        return NJson::JSON_NULL;
    } else if (NJson::ReadJsonFastTree(resultStr, &resultJson, throwOnParseError)) {
        return resultJson;
    } else {
        return resultStr;
    }
}

NJson::TJsonValue NDrive::ISettingGetter::GetJsonValue(TConstArrayRef<TString> pathes, const TString& key, TString* resultPath, bool throwOnParseError) const {
    for (auto&& i : pathes) {
        TString path = i;
        if (path && key) {
            path += "." + key;
        } else if (key) {
            path = key;
        } else {
            continue;
        }
        auto result = GetJsonValue(path, throwOnParseError);
        if (result.IsDefined()) {
            if (resultPath) {
                *resultPath = path;
            }
            return result;
        }
    }
    if (resultPath) {
        *resultPath = "";
    }
    return NJson::JSON_NULL;
}

bool NDrive::ISettings::SetValue(const TString& key, const TString& value, const TString& userId) const {
    TSetting s(key, value);
    return SetValues({s}, userId);
}
