#include "user_position_context.h"

TUserPositionContext::TUserPositionContext(IReplyContext::TPtr context) {
    if (!context) {
        return;
    }
    TStringBuf latStr(context->GetRequestData().HeaderInOrEmpty("Lat"));
    TStringBuf lonStr(context->GetRequestData().HeaderInOrEmpty("Lon"));
    double lat;
    double lon;
    if (!TryFromString<double>(latStr, lat) || !TryFromString<double>(lonStr, lon)) {
        TString userPosition = context->GetCgiParameters().Get("user_position");
        TGeoCoord coordUserPosition;
        if (TryFromString<TGeoCoord>(userPosition, coordUserPosition)) {
            SetUserPosition(coordUserPosition);
        }
    } else {
        TGeoCoord coordUserPosition(lon, lat);
        SetUserPosition(coordUserPosition);
    }
}
