#include "users_contacts.h"

#include <rtline/library/json/parse.h>

#include <util/string/cast.h>

ui64 TUserIdInfo::GetPassportUid() const {
    ui64 result = 0;
    TryFromString(Uid, result);
    return result;
}

template <>
NJson::TJsonValue NJson::ToJson(const TUserContacts& object) {
    NJson::TJsonValue result;
    NJson::InsertNonNull(result, "id", object.GetUserId());
    NJson::InsertNonNull(result, "email", object.GetEmail());
    NJson::InsertNonNull(result, "phone", object.GetPhone());
    NJson::InsertNonNull(result, "uid", object.GetUid());
    return result;
}
