#pragma once

#include <util/generic/string.h>

class TUserIdInfo {
protected:
    TString Uid;
    TString UserId;

public:
    ui64 GetPassportUid() const;

    const TString& GetUid() const {
        return Uid;
    }
    const TString& GetUserId() const {
        return UserId;
    }

    TUserIdInfo& SetUid(const TString& uid) {
        Uid = uid;
        return *this;
    }
    TUserIdInfo& SetUserId(const TString& userId) {
        UserId = userId;
        return *this;
    }
};

class TUserContacts: public TUserIdInfo {
protected:
    TString Email;
    TString Phone;

public:
    TUserContacts() = default;
    TUserContacts(const TString& uid) {
        SetUid(uid);
    }

    const TString& GetPhone() const {
        return Phone;
    }
    const TString& GetEmail() const {
        return Email;
    }
    TUserContacts& SetPhone(const TString& phone) {
        Phone = phone;
        return *this;
    }
    TUserContacts& SetEmail(const TString& email) {
        Email = email;
        return *this;
    }
};
