#pragma once

#include <drive/backend/actions/abstract/action.h>

#include <util/generic/serialized_enum.h>

class TAdministrativeAction: public TUserAction {
private:
    using TBase = TUserAction;

private:
    static TFactory::TRegistrator<TAdministrativeAction> Registrator;

public:
    enum class EAction {
        Add = 0 /* "add" */,
        Remove = 1 /* "remove" */,
        Modify = 2 /* "modify" */,
        ModifyStructure = 3 /* "modify_structure" */,
        Observe = 4 /* "observe" */,
        ObserveStructure = 5 /* "observe_structure" */,
        Delegation = 6 /* "delegation" */,
        DebugInfo = 7 /* "debug_info" */,
        Control = 8 /* "control" */,
        Confirm = 9 /* "confirm" */,
        Reject = 10 /* "reject" */,
        Propose = 11 /* "propose" */,
        Send = 12 /* "send" */,
        SendForce = 13 /* "send_force" */
    };

    enum class EEntity {
        Action = 0 /* "action" */,
        Tag = 1 /* "tag" */,
        Role = 2 /* "role" */,
        User = 3 /* "user" */,
        Login = 4 /* "login" */,
        Car = 5 /* "car" */,
        Settings = 6 /* "settings" */,
        Areas = 7 /* "areas" */,
        Payment = 8 /* "payment" */,
        Landings = 9 /* "landings" */,
        MDS = 10 /* "mds" */,
        Models = 11 /* "models" */,
        Heads = 12 /* "heads" */,
        StateFilters = 13 /* "state_filters" */,
        Documents = 14 /* "documents" */,
        Localization = 15 /* "localization" */,
        RTBackground = 16 /* "rt_background" */,
        MajorApi = 17 /* "major_api" */,
        Wallet = 18 /* "wallet" */,
        Notifier = 19 /* "notifier" */,
        StaffHierarchy = 20 /* "staff_hierarchy" */,
        DeletedUser = 21 /* "deleted_user" */,
        Maintenance = 22 /* "maintenance" */,
        PromoCodes = 23 /* "promo_codes" */,
        ChatsList = 24 /* "chats_list" */,
        ChatMessage = 25 /* "chat_message" */,
        ChatResource = 26 /* "chat_resource" */,
        Secrets = 27 /* "secrets" */,
        ExternalPromo = 28 /* "external_promo" */,
        ChatSticker = 29 /* "chat_sticker" */,
        Tyre = 30 /* "tyre" */,
        SupportRequestCategorization = 31 /* "support_request_categorization" */,
        Fine = 32 /* "fine" */,
        SupportCategorizationTree = 33 /* "support_categorization_tree" */,
        Scheme = 34 /* "scheme" */,
        Terminal = 35 /* "terminal" */,
        Stories = 36 /* "stories" */,
        Incident = 37 /* "incident" */,
        ExternalAccessToken = 38 /* "external_access_token" */,
        B2BOrganization = 39 /* "b2b_organization" */,
        ChatRobot = 40 /* "chat_robot" */,
        ServiceRoute = 41 /* "service_route" */,
        WebPhoneCalls = 42 /* "web_phone_calls" */,
        AudiotelePhoneCalls = 43 /* "audiotele_phone_calls" */,
        UserDocumentsCheck = 44 /* "user_documents_check" */,
        NamedFilter = 45 /* "named_filter" */,
        Zone = 46 /* "zone" */,
        UserInsurance = 47 /* "user_insurance" */,
        SignalConfiguration = 48 /* "signal_configuration" */,
        TechDispatch = 49 /* "tech_dispatch" */,
    };

private:
    TSet<TString> Handlers;
    TSet<TString> Instances;
    TSet<TString> Roles;
    TSet<TString> Commands;
    TSet<TString> Wallets;
    TSet<TString> TagTypes;
    TMap<TString, double> Limits;
    TSet<TString> PromoCodes;
    TSet<TString> MdsBuckets;
    TSet<TString> ChatRobots;

    R_FIELD(TSet<EAction>, Actions);
    R_FIELD(TSet<EEntity>, Entities);
    R_READONLY(TSet<TString>, UserIds);
    R_FIELD(TSet<TString>, SettingPrefixes);

    R_READONLY(TTagsFilter, ActionTagsFilter);
    R_FIELD(TTagsFilter, RTBackgroundTagsFilter);
    R_FIELD(TSet<TString>, ActionTypes);
    R_FIELD(TSet<TString>, B2BOrganizations);

public:
    using TBase::TBase;

    TMaybe<double> GetLimit(const TString& instance) const;
    bool CheckAction(const EAction action, const EEntity entity, const TString& handler, const TString& instance, const TMaybe<TSet<TString>>& instanceTags) const;
    TMaybe<TSet<TString>> GetInstances(const EAction action, const EEntity entity, const TString& handler) const;

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    static TString GetTypeName() {
        return "adm";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }
};
