#include "disable.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/roles/manager.h>

#include <rtline/library/json/parse.h>

bool TDisableAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& value) {
    return
        TBase::DeserializeSpecialsFromJson(value) &&
        NJson::ParseField(value["actions"], Actions);
}

NJson::TJsonValue TDisableAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result = TBase::SerializeSpecialsToJson();
    result["actions"] = NJson::ToJson(Actions);
    return result;
}

NDrive::TScheme TDisableAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::DoGetScheme(server);
    auto actionNames = server->GetDriveAPI()->GetRolesManager()->GetActionsDB().GetActionNamesWithType<TUserAction>(/*reportDeprecated=*/true);
    result.Add<TFSVariants>("actions", "Actions to disable").SetMultiSelect(true).SetVariants(actionNames);
    return result;
}

TDisableAction::TFactory::TRegistrator<TDisableAction> TDisableAction::Registrator(TDisableAction::Type());
