#pragma once

#include <drive/backend/actions/abstract/action.h>

class TDisableAction: public TUserAction {
private:
    using TBase = TUserAction;

public:
    using TBase::TBase;

    const TSet<TString>& GetActions() const {
        return Actions;
    }
    void SetActions(TSet<TString>&& actions) {
        Actions = std::move(actions);
    }

    static TString Type() {
        return "disable_action";
    }
    virtual TString GetType() const override {
        return Type();
    }

protected:
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

private:
    TSet<TString> Actions;

private:
    static TFactory::TRegistrator<TDisableAction> Registrator;
};
