#include "email_after_acceptance.h"

#include <drive/backend/data/chargable.h>
#include <drive/backend/data/event_tag.h>
#include <drive/backend/data/evolution_policy.h>
#include <drive/backend/data/notifications_tags.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/database/transaction/assert.h>

TUserAction::TFactory::TRegistrator<TEmailAfterAcceptanceEvolutionPolicyAction> TEmailAfterAcceptanceEvolutionPolicyAction::Registrator(TEmailAfterAcceptanceEvolutionPolicyAction::GetTypeName());

ITag::TAggregateEvolutionPolicy TEmailAfterAcceptanceEvolutionPolicyAction::BuildEvolutionPolicy(
    const TConstDBTag& dbTag,
    ITag::TPtr newTag,
    const NDrive::IServer* /*server*/,
    const TUserPermissions& /*permissions*/,
    const NJson::TJsonValue& /*requestData*/,
    const EEvolutionMode /*eMode*/,
    NDrive::TEntitySession& /*session*/
) const {
    if (!dbTag.Is<TChargableTag>()) {
        return {};
    }

    if (dbTag->GetName() != TChargableTag::Acceptance || Yensured(newTag)->GetName() != TChargableTag::Riding) {
        return {};
    }

    ITag::TAggregateEvolutionPolicy result;
    result.Policies.push_back(new TEmailAfterRideEvolutionPolicy(NotificationType));

    return result;
}

bool TEmailAfterAcceptanceEvolutionPolicyAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& value) {
    return NJson::ParseField(value["notification_type"], NotificationType);
}

NJson::TJsonValue TEmailAfterAcceptanceEvolutionPolicyAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result;
    NJson::InsertField(result, "notification_type", NotificationType);
    return result;
}

NDrive::TScheme TEmailAfterAcceptanceEvolutionPolicyAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::DoGetScheme(server);
    result.Add<TFSString>("notification_type", "Тип уведомления");
    return result;
}
