#pragma once

#include <drive/backend/actions/evolution_policy.h>

class TEmailAfterAcceptanceEvolutionPolicyAction: public IEvolutionPolicyAction {
private:
    using TBase = IEvolutionPolicyAction;

public:
    R_FIELD(TString, NotificationType);

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "email_after_acceptance_policy_action";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual ITag::TAggregateEvolutionPolicy BuildEvolutionPolicy(const TConstDBTag& dbTag, ITag::TPtr newTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NJson::TJsonValue& requestData, const EEvolutionMode eMode, NDrive::TEntitySession& session) const override;

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

private:
    static TFactory::TRegistrator<TEmailAfterAcceptanceEvolutionPolicyAction> Registrator;
};
