#include "email_after_finish_ride.h"

#include <drive/backend/data/chargable.h>
#include <drive/backend/data/event_tag.h>
#include <drive/backend/data/evolution_policy.h>
#include <drive/backend/data/leasing/company.h>
#include <drive/backend/data/notifications_tags.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/database/transaction/assert.h>


TUserAction::TFactory::TRegistrator<TEmailAfterFinishRideEvolutionPolicyAction> TEmailAfterFinishRideEvolutionPolicyAction::Registrator(TEmailAfterFinishRideEvolutionPolicyAction::GetTypeName());

ITag::TAggregateEvolutionPolicy TEmailAfterFinishRideEvolutionPolicyAction::BuildEvolutionPolicy(
    const TConstDBTag& dbTag,
    ITag::TPtr newTag,
    const NDrive::IServer* /*server*/,
    const TUserPermissions& /*permissions*/,
    const NJson::TJsonValue& /*requestData*/,
    const EEvolutionMode /*eMode*/,
    NDrive::TEntitySession& /*session*/
) const {
    if (!dbTag.Is<TChargableTag>()) {
        return {};
    }
    if (!((dbTag->GetName() == TChargableTag::Riding || dbTag->GetName() == TChargableTag::Parking) && Yensured(newTag)->GetName() == TChargableTag::Reservation)) {
        return {};
    }
    ITag::TAggregateEvolutionPolicy result;
    result.Policies.push_back(new TEmailAfterRideEvolutionPolicy(NotificationType));
    return result;
}

bool TEmailAfterFinishRideEvolutionPolicyAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& value) {
    return
        NJson::ParseField(value["notification_type"], NotificationType);
}

NJson::TJsonValue TEmailAfterFinishRideEvolutionPolicyAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result;
    NJson::InsertField(result, "notification_type", NotificationType);
    return result;
}

NDrive::TScheme TEmailAfterFinishRideEvolutionPolicyAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::DoGetScheme(server);
    result.Add<TFSString>("notification_type", "Тип уведомления");
    return result;
}
