#include "flag.h"

NDrive::TScheme TFlagsAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::DoGetScheme(server);
    NDrive::TScheme& element = result.Add<TFSArray>("flags", "Flags to add to user session").SetElement<NDrive::TScheme>();
    element.Add<TFSString>("key");
    element.Add<TFSString>("value");
    return result;
}

NJson::TJsonValue TFlagsAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result = TBase::SerializeSpecialsToJson();
    NJson::TJsonValue& flags = result.InsertValue("flags", NJson::JSON_ARRAY);
    for (auto&&[key, value] : Flags) {
        NJson::TJsonValue flag;
        flag["key"] = key;
        flag["value"] = value.GetStringRobust();
        flags.AppendValue(std::move(flag));
    }
    return result;
}

bool TFlagsAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& value) {
    if (!TBase::DeserializeSpecialsFromJson(value)) {
        return false;
    }
    const NJson::TJsonValue& flags = value["flags"];
    if (flags.IsDefined() && !flags.IsArray()) {
        return false;
    }
    for (auto&& flag : flags.GetArray()) {
        TKey key;
        if (!flag["key"].GetString(&key)) {
            return false;
        }
        TValue value;
        const NJson::TJsonValue& v = flag["value"];
        if (v.IsDefined() && !v.IsString()) {
            return false;
        }
        if (!v.IsDefined()) {
            value = NJson::JSON_NULL;
        } else if (!NJson::ReadJsonFastTree(v.GetString(), &value)) {
            value = v;
        }
        Flags[key] = std::move(value);
    }
    return true;
}

TUserAction::TFactory::TRegistrator<TFlagsAction> TFlagsAction::Registrator(TFlagsAction::GetTypeName());
