#pragma once

#include <drive/backend/actions/abstract/action.h>

#include <rtline/util/types/accessor.h>

class TFlagsAction: public TUserAction {
public:
    using TKey = TString;
    using TValue = NJson::TJsonValue;
    using TFlags = TMap<TKey, TValue>;
private:
    using TBase = TUserAction;
    R_FIELD(TFlags, Flags);
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "flags";
    }
    TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;

private:
    static TFactory::TRegistrator<TFlagsAction> Registrator;
};
