#pragma once

#include <drive/backend/actions/abstract/action.h>

#include <drive/backend/cars/car.h>
#include <drive/backend/cars/hardware.h>
#include <drive/backend/users/user.h>

class TInfoAccessAction: public TUserAction {
private:
    using TBase = TUserAction;

private:
    static TFactory::TRegistrator<TInfoAccessAction> Registrator;

private:
    R_READONLY(TSet<TString>, AvailableDocuments);
    R_FIELD(NAttachmentReport::TStructureReportTraits, CarRegistryTraits, NAttachmentReport::NoStructureTraits);
    R_FIELD(NDeviceReport::TReportTraits, DeviceTraits, NDeviceReport::NoTraits);
    R_FIELD(NDeviceReport::TReportTraits, DeviceSearchTraits, NDeviceReport::NoTraits);
    R_FIELD(NUserReport::TReportTraits, UserTraits, NUserReport::NoTraits);
    R_FIELD(NUserReport::TReportTraits, UserSearchTraits, NUserReport::NoTraits);
    R_FIELD(ui32, MessageVisibilityTraits, 0);

public:
    using TBase::TBase;

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    static TString GetTypeName() {
        return "iacc";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }
};
