#pragma once
#include <drive/backend/actions/abstract/action.h>

#include <drive/library/cpp/scheme/scheme.h>

class TLockAction: public TUserAction {
    R_FIELD(ui32, LockedResourcesLimit, 1);
    R_FIELD(TString, LockedTags);

private:
    using TBase = TUserAction;
    TRegExMatch Matcher;
    static TFactory::TRegistrator<TLockAction> Registrator;

public:

    using TBase::TBase;

    bool Match(const TString& tagName) const {
        if (LockedTags.StartsWith("$")) {
            return Matcher.Match(tagName.data());
        } else {
            return tagName == LockedTags;
        }
    }

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override {
        LockedResourcesLimit = 1;
        if (jsonValue.Has("locked_resources_limit")) {
            if (!jsonValue["locked_resources_limit"].IsInteger()) {
                return false;
            }
            LockedResourcesLimit = jsonValue["locked_resources_limit"].GetInteger();
        } else {
            if (jsonValue.Has("lock_multi")) {
                if (!jsonValue["lock_multi"].IsBoolean())
                    return false;
                if (jsonValue["lock_multi"].GetBoolean()) {
                    LockedResourcesLimit = 10000;
                }
            }
        }
        if (jsonValue.Has("locked_tags") && jsonValue["locked_tags"].IsString()) {
            LockedTags = jsonValue["locked_tags"].GetString();
            if (LockedTags.StartsWith("$")) {
                Matcher.Compile(LockedTags.substr(1));
                return Matcher.IsCompiled();
            }
        }
        return true;
    }

    virtual NJson::TJsonValue SerializeSpecialsToJson() const override {
        NJson::TJsonValue result;
        result["locked_resources_limit"] = LockedResourcesLimit;
        result["locked_tags"] = LockedTags;
        return result;
    }

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override {
        NDrive::TScheme result = TBase::DoGetScheme(server);
        result.Add<TFSNumeric>("locked_resources_limit", "Максимальное количество одновременно занятых ресурсов").SetMin(0).SetMax(100000).SetDefault(1);
        result.Add<TFSString>("locked_tags", "Ограничивать взятие в работу тегов по рег. выражению").SetRequired(false);
        return result;
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "lock";
    }
};
