#include "override_settings.h"

#include <drive/backend/database/drive_api.h>

TUserAction::TFactory::TRegistrator<TOverrideSettingsAction> TOverrideSettingsAction::Registrator(TOverrideSettingsAction::GetTypeName());

bool TOverrideSettingsAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) {
    if (!TBase::DeserializeSpecialsFromJson(jsonValue)) {
        return false;
    }

    if (jsonValue.Has("settings")) {
        const NJson::TJsonValue::TArray* settingsArray;
        if (!jsonValue["settings"].GetArrayPointer(&settingsArray)) {
            return false;
        }
        for (auto&& i : *settingsArray) {
            if (i["key"].IsString() && i["value"].IsString()) {
                Settings.emplace(i["key"].GetStringSafe(), i["value"].GetStringSafe());
            }
        }
    }
    return true;
}

NJson::TJsonValue TOverrideSettingsAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result;
    NJson::TJsonValue& settingsJson = result.InsertValue("settings", NJson::JSON_MAP);
    for (auto&& i : Settings) {
        NJson::TJsonValue& item = settingsJson.AppendValue(NJson::JSON_MAP);
        item.InsertValue("key", i.first);
        item.InsertValue("value", i.second);
    }
    return result;
}

NDrive::TScheme TOverrideSettingsAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::DoGetScheme(server);
    NDrive::TScheme& elemScheme = result.Add<TFSArray>("settings").SetElement<NDrive::TScheme>();
    elemScheme.Add<TFSString>("key");
    elemScheme.Add<TFSText>("value");
    return result;
}
