#pragma once
#include <drive/backend/actions/abstract/action.h>

#include <library/cpp/cgiparam/cgiparam.h>

#include <util/string/subst.h>

class TOverrideSettingsAction: public TUserAction {
private:
    using TBase = TUserAction;
    using TSettings = TMap<TString, TString>;

public:
    R_FIELD(TSettings, Settings);

public:
    TOverrideSettingsAction() = default;
    TOverrideSettingsAction(const TString& name)
        : TBase(name)
    {
    }

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;

    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

    static TString GetTypeName() {
        return "override_settings";
    }

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

private:
    static TFactory::TRegistrator<TOverrideSettingsAction> Registrator;
};
