#pragma once

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/data/chargable.h>

namespace NDrive {

class TSessionPhotoScreenAction : public TUserAction {
private:
    using TBase = TUserAction;

    static TFactory::TRegistrator<TSessionPhotoScreenAction> Registrator;

    R_FIELD(TSet<TString>, LastSegments);
    R_FIELD(TDuration, LastDuration);
    R_FIELD(TDuration, MinimalLastDuration);
    R_FIELD(double, UserDistance, 0);
    R_FIELD(TTagsFilter, OfferTagsFilter);
    // Fields for client.
    R_FIELD(bool, PhotoRequired, false);
    R_FIELD(i32, PhotoCount, 0);

public:
    using TBase::TBase;

    static const TString TypeName;

    TString GetType() const override;

    NJson::TJsonValue SerializeSpecialsToJson() const override;
    bool DeserializeSpecialsFromJson(const NJson::TJsonValue& json) override;
    NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    bool CheckSession(
        const NDrive::IServer& server,
        const TUserPermissions& permissions,
        const TFullCompiledRiding& ride,
        const TMaybe<NDrive::TLocation>& carLocation
    ) const;
};

}
