#include "user_option.h"

TUserAction::TFactory::TRegistrator<TAdditionalPricedFeatureAction> TAdditionalPricedFeatureAction::Registrator(TAdditionalPricedFeatureAction::GetTypeName());


NDrive::TScheme TUserOptionAction::DoGetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TUserAction::DoGetScheme(server);
    result.Add<TFSStructure>("user_option_meta", "Метаданные опции").SetStructure(TUserOptionMeta::GetScheme(server));
    return result;
}

bool TUserOptionAction::DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) {
    if (!TUserAction::DeserializeSpecialsFromJson(jsonValue)) {
        return false;
    }
    if (!TUserOptionAction::DeserializeFromJson(jsonValue["user_option_meta"])) {
        return false;
    }
    return true;
}

NJson::TJsonValue TUserOptionAction::SerializeSpecialsToJson() const {
    NJson::TJsonValue result = TUserAction::SerializeSpecialsToJson();
    result.InsertValue("user_option_meta", TUserOptionMeta::SerializeToJson());
    return result;
}
