#pragma once

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/user_options/user_option.h>

class TUserOptionAction: public TUserAction, public TUserOptionMeta {
protected:
    NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;
public:
    virtual IUserOption::TPtr Build(const IUserOption::TContext& context) const = 0;
};

class TAdditionalPricedFeatureAction: public TUserOptionAction {
private:
    static TFactory::TRegistrator<TAdditionalPricedFeatureAction> Registrator;
public:
    static TString GetTypeName() {
        return "priced_user_option";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual IUserOption::TPtr Build(const IUserOption::TContext& context) const override {
        return new TExtendPriceOption(context, *this);
    }
};
