#pragma once

#include <drive/backend/alerts/condition.h>

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/database/drive_api.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

#include <util/generic/vector.h>


class INotifierActionBase : public NAlerts::ICheckerAction {
public:
    using TFactory = NObjectFactory::TObjectFactory<INotifierActionBase, TString>;
    using TPtr = TAtomicSharedPtr<INotifierActionBase>;

public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue SerializeToJson() const override;

    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual TString GetActionType() const = 0;
    static INotifierActionBase::TPtr BuildFromJson(const NJson::TJsonValue& json);
    TString PatchData(const TString& objectId, const TString& original, const NAlerts::TFetcherContext& context) const;
    static TString PatchData(const TString& original, const TMap<TString, TString>& params);
    static TString PatchData(const TString& objectId, const TString& original, const NAlerts::TFetcherContext& context, ui32 timezone);

    void DoApply(const TString& /*objectId*/, const NAlerts::TFetchedMap& /*parameters*/, NAlerts::TFetcherContext& /*context*/) override;

protected:
    R_READONLY(TString, HRCheckerName);
    R_READONLY(bool, SaveFetchedData, false);
    using TFetchedData = TMap<TString, TMap<TString, TString>>;
    R_READONLY(TFetchedData, FetchedParameters);
    R_READONLY(ui32, Timezone, 3);
};
