#pragma once

#include "base.h"

class TCallAction: public INotifierActionBase {
public:
    enum class ECallActionType {
        Connect = 0 /* "connect" */,
        Disconnect = 1 /* "disconnect" */,
        Pause = 2 /* "pause" */,
        Resume = 3 /* "resume" */,
    };

    R_FIELD(ECallActionType, CallActionType, ECallActionType::Connect);
    R_FIELD(TVector<TString>, InternalTags);
    R_FIELD(TVector<TString>, AudioteleTags);
    R_FIELD(TVector<TString>, NextcontactTags);
    R_FIELD(TString, AgentIdSettingTagName);
    R_FIELD(TString, AgentIdSettingFieldName);

public:
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    TMaybe<TString> GetPhoneNumber(TUserPermissions::TPtr permissions, NAlerts::TFetcherContext& context) const;
    TVector<TString> GetCallQueues(const NAlerts::TFetcherContext& context, const TVector<TString>& callTagNames) const;
    bool ProcessInternalCallCenter(const TString& agentId, NAlerts::TFetcherContext& context, const TVector<TString>& queues, TMessagesCollector& errors) const;
    static TFactory::TRegistrator<TCallAction> Registrator;
};
