#pragma once
#include "base.h"

class TCarInfoObjectTagAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    TString TagData;
    TString ObjectId;
    NEntityTagsManager::EEntityType ObjectType;
    static TFactory::TRegistrator<TCarInfoObjectTagAction> Registrator;
};
