#pragma once

#include "base.h"

#include <drive/backend/chat/engine.h>

class TChatAction : public INotifierActionBase {
    R_READONLY(TString, MessageTemplate);
    R_READONLY(TString, ChatRobot);
    R_READONLY(TString, Topic);
    R_READONLY(NDrive::NChat::TMessage::EMessageType, MessageType, NDrive::NChat::TMessage::EMessageType::Plaintext);

public:
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual TString GetActionType() const override;
private:
    static TFactory::TRegistrator<TChatAction> Registrator;
};

class TChatNodeAction : public INotifierActionBase {
    R_READONLY(TString, NodeId);
    R_READONLY(TString, ChatRobot);
    R_READONLY(TString, Topic);
    R_READONLY(bool, SendMessages, true);

public:
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual TString GetActionType() const override;
private:
    static TFactory::TRegistrator<TChatNodeAction> Registrator;
};
