#include "composite.h"


void TCompositeAction::DoApply(const TString& objectId, const NAlerts::TFetchedMap& parameters, NAlerts::TFetcherContext& context) {
    INotifierActionBase::DoApply(objectId, parameters, context);
    for (auto&& action : Actions) {
        action->DoApply(objectId, parameters, context);
    }
}

bool TCompositeAction::DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) {
    for (auto&& action : Actions) {
        if (!action->DoFinish(objectIds, context)) {
            return false;
        }
    }
    return true;
}

TString TCompositeAction::GetActionType() const {
    return TypeName;
}

void TCompositeAction::SetEntityType(NAlerts::EAlertEntityType entityType) {
    TBase::SetEntityType(entityType);
    for (auto&& action : Actions) {
        action->SetEntityType(entityType);
    }
}

bool TCompositeAction::DeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    if (!jsonInfo["actions"].IsArray()) {
        return false;
    }
    for (auto&& actionJson : jsonInfo["actions"].GetArray()) {
        auto impl = INotifierActionBase::BuildFromJson(actionJson);
        if (!impl) {
            return false;
        }
        Actions.emplace_back(std::move(impl));
    }
    return INotifierActionBase::DeserializeFromJson(jsonInfo);
}

NJson::TJsonValue TCompositeAction::SerializeToJson() const {
    NJson::TJsonValue result = INotifierActionBase::SerializeToJson();
    for (auto&& action : Actions) {
        result["actions"].AppendValue(action->SerializeToJson());
    }
    return result;
}

NDrive::TScheme TCompositeAction::GetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = INotifierActionBase::GetScheme(server);
    scheme.Add<TFSJson>("actions", "Список действий");
    return scheme;
}
